// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials
import aws.sdk.kotlin.services.quicksight.model.DataSourceParameters
import aws.sdk.kotlin.services.quicksight.model.SslProperties
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDataSourceOperationSerializer: HttpSerializer.NonStreaming<UpdateDataSourceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDataSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.dataSourceId) { "dataSourceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("data-sources"))
                add(PercentEncoding.SmithyLabel.encode(input.dataSourceId))
            }
        }

        val payload = serializeUpdateDataSourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDataSourceOperationBody(context: ExecutionContext, input: UpdateDataSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Credentials"))
    val DATASOURCEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSourceParameters"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SSLPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SslProperties"))
    val VPCCONNECTIONPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConnectionProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIALS_DESCRIPTOR)
        field(DATASOURCEPARAMETERS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SSLPROPERTIES_DESCRIPTOR)
        field(VPCCONNECTIONPROPERTIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.credentials?.let { field(CREDENTIALS_DESCRIPTOR, it, ::serializeDataSourceCredentialsDocument) }
        input.dataSourceParameters?.let { field(DATASOURCEPARAMETERS_DESCRIPTOR, it, ::serializeDataSourceParametersDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.sslProperties?.let { field(SSLPROPERTIES_DESCRIPTOR, it, ::serializeSslPropertiesDocument) }
        input.vpcConnectionProperties?.let { field(VPCCONNECTIONPROPERTIES_DESCRIPTOR, it, ::serializeVpcConnectionPropertiesDocument) }
    }
    return serializer.toByteArray()
}
