// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition
import aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity
import aws.sdk.kotlin.services.quicksight.model.Parameters
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.ValidationStrategy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAnalysisOperationSerializer: HttpSerializer.NonStreaming<UpdateAnalysisRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAnalysisRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.analysisId) { "analysisId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("analyses"))
                add(PercentEncoding.SmithyLabel.encode(input.analysisId))
            }
        }

        val payload = serializeUpdateAnalysisOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAnalysisOperationBody(context: ExecutionContext, input: UpdateAnalysisRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Definition"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Parameters"))
    val SOURCEENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceEntity"))
    val THEMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ThemeArn"))
    val VALIDATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationStrategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFINITION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(SOURCEENTITY_DESCRIPTOR)
        field(THEMEARN_DESCRIPTOR)
        field(VALIDATIONSTRATEGY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.definition?.let { field(DEFINITION_DESCRIPTOR, it, ::serializeAnalysisDefinitionDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parameters?.let { field(PARAMETERS_DESCRIPTOR, it, ::serializeParametersDocument) }
        input.sourceEntity?.let { field(SOURCEENTITY_DESCRIPTOR, it, ::serializeAnalysisSourceEntityDocument) }
        input.themeArn?.let { field(THEMEARN_DESCRIPTOR, it) }
        input.validationStrategy?.let { field(VALIDATIONSTRATEGY_DESCRIPTOR, it, ::serializeValidationStrategyDocument) }
    }
    return serializer.toByteArray()
}
