// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportFailureAction
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverrideParameters
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverridePermissions
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverrideTags
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverrideValidationStrategy
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportSource
import aws.sdk.kotlin.services.quicksight.model.StartAssetBundleImportJobRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartAssetBundleImportJobOperationSerializer: HttpSerializer.NonStreaming<StartAssetBundleImportJobRequest> {
    override fun serialize(context: ExecutionContext, input: StartAssetBundleImportJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("asset-bundle-import-jobs"))
                add(PercentEncoding.Path.encode("import"))
            }
        }

        val payload = serializeStartAssetBundleImportJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartAssetBundleImportJobOperationBody(context: ExecutionContext, input: StartAssetBundleImportJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ASSETBUNDLEIMPORTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssetBundleImportJobId"))
    val ASSETBUNDLEIMPORTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AssetBundleImportSource"))
    val FAILUREACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FailureAction"))
    val OVERRIDEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverrideParameters"))
    val OVERRIDEPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverridePermissions"))
    val OVERRIDETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverrideTags"))
    val OVERRIDEVALIDATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverrideValidationStrategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETBUNDLEIMPORTJOBID_DESCRIPTOR)
        field(ASSETBUNDLEIMPORTSOURCE_DESCRIPTOR)
        field(FAILUREACTION_DESCRIPTOR)
        field(OVERRIDEPARAMETERS_DESCRIPTOR)
        field(OVERRIDEPERMISSIONS_DESCRIPTOR)
        field(OVERRIDETAGS_DESCRIPTOR)
        field(OVERRIDEVALIDATIONSTRATEGY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.assetBundleImportJobId?.let { field(ASSETBUNDLEIMPORTJOBID_DESCRIPTOR, it) }
        input.assetBundleImportSource?.let { field(ASSETBUNDLEIMPORTSOURCE_DESCRIPTOR, it, ::serializeAssetBundleImportSourceDocument) }
        input.failureAction?.let { field(FAILUREACTION_DESCRIPTOR, it.value) }
        input.overrideParameters?.let { field(OVERRIDEPARAMETERS_DESCRIPTOR, it, ::serializeAssetBundleImportJobOverrideParametersDocument) }
        input.overridePermissions?.let { field(OVERRIDEPERMISSIONS_DESCRIPTOR, it, ::serializeAssetBundleImportJobOverridePermissionsDocument) }
        input.overrideTags?.let { field(OVERRIDETAGS_DESCRIPTOR, it, ::serializeAssetBundleImportJobOverrideTagsDocument) }
        input.overrideValidationStrategy?.let { field(OVERRIDEVALIDATIONSTRATEGY_DESCRIPTOR, it, ::serializeAssetBundleImportJobOverrideValidationStrategyDocument) }
    }
    return serializer.toByteArray()
}
