// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.ListTopicRefreshSchedulesResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.sdk.kotlin.services.quicksight.model.TopicRefreshScheduleSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListTopicRefreshSchedulesOperationDeserializer: HttpDeserializer.NonStreaming<ListTopicRefreshSchedulesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTopicRefreshSchedulesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTopicRefreshSchedulesError(context, call, payload)
        }
        val builder = ListTopicRefreshSchedulesResponse.Builder()

        if (payload != null) {
            deserializeListTopicRefreshSchedulesOperationBody(builder, payload)
        }
        builder.status = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTopicRefreshSchedulesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceExistsException" -> ResourceExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTopicRefreshSchedulesOperationBody(builder: ListTopicRefreshSchedulesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REFRESHSCHEDULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RefreshSchedules"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val TOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TopicArn"))
    val TOPICID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TopicId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REFRESHSCHEDULES_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(TOPICARN_DESCRIPTOR)
        field(TOPICID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REFRESHSCHEDULES_DESCRIPTOR.index -> builder.refreshSchedules =
                    deserializer.deserializeList(REFRESHSCHEDULES_DESCRIPTOR) {
                        val col0 = mutableListOf<TopicRefreshScheduleSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTopicRefreshScheduleSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                TOPICARN_DESCRIPTOR.index -> builder.topicArn = deserializeString()
                TOPICID_DESCRIPTOR.index -> builder.topicId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
