// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.EmbeddingIdentityType
import aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class GetDashboardEmbedUrlOperationSerializer: HttpSerializer.NonStreaming<GetDashboardEmbedUrlRequest> {
    override fun serialize(context: ExecutionContext, input: GetDashboardEmbedUrlRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.dashboardId) { "dashboardId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("dashboards"))
                add(PercentEncoding.SmithyLabel.encode(input.dashboardId))
                add(PercentEncoding.Path.encode("embed-url"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.additionalDashboardIds != null) addAll("additional-dashboard-ids", input.additionalDashboardIds)
                if (input.identityType != null) add("creds-type", input.identityType.value)
                if (input.namespace != null) add("namespace", input.namespace)
                if (input.resetDisabled != null) add("reset-disabled", input.resetDisabled.toString())
                if (input.sessionLifetimeInMinutes != null) add("session-lifetime", input.sessionLifetimeInMinutes.toString())
                if (input.statePersistenceEnabled != null) add("state-persistence-enabled", input.statePersistenceEnabled.toString())
                if (input.undoRedoDisabled != null) add("undo-redo-disabled", input.undoRedoDisabled.toString())
                if (input.userArn != null) add("user-arn", input.userArn)
            }
        }

        return builder
    }
}
