// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.DescribeKeyRegistrationResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.sdk.kotlin.services.quicksight.model.RegisteredCustomerManagedKey
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeKeyRegistrationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeKeyRegistrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeKeyRegistrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeKeyRegistrationError(context, call, payload)
        }
        val builder = DescribeKeyRegistrationResponse.Builder()

        if (payload != null) {
            deserializeDescribeKeyRegistrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeKeyRegistrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeKeyRegistrationOperationBody(builder: DescribeKeyRegistrationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AwsAccountId"))
    val KEYREGISTRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("KeyRegistration"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSACCOUNTID_DESCRIPTOR)
        field(KEYREGISTRATION_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                KEYREGISTRATION_DESCRIPTOR.index -> builder.keyRegistration =
                    deserializer.deserializeList(KEYREGISTRATION_DESCRIPTOR) {
                        val col0 = mutableListOf<RegisteredCustomerManagedKey>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRegisteredCustomerManagedKeyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
