// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration
import aws.sdk.kotlin.services.quicksight.model.SnapshotJobStatus
import aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfigurationRedacted
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeDashboardSnapshotJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDashboardSnapshotJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDashboardSnapshotJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDashboardSnapshotJobError(context, call, payload)
        }
        val builder = DescribeDashboardSnapshotJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeDashboardSnapshotJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDashboardSnapshotJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedUserEditionException" -> UnsupportedUserEditionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDashboardSnapshotJobOperationBody(builder: DescribeDashboardSnapshotJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AwsAccountId"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DashboardId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val SNAPSHOTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapshotConfiguration"))
    val SNAPSHOTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnapshotJobId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Status"))
    val USERCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AWSACCOUNTID_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(DASHBOARDID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(SNAPSHOTCONFIGURATION_DESCRIPTOR)
        field(SNAPSHOTJOBID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { SnapshotJobStatus.fromValue(it) }
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                SNAPSHOTCONFIGURATION_DESCRIPTOR.index -> builder.snapshotConfiguration = deserializeSnapshotConfigurationDocument(deserializer)
                SNAPSHOTJOBID_DESCRIPTOR.index -> builder.snapshotJobId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeInt()
                USERCONFIGURATION_DESCRIPTOR.index -> builder.userConfiguration = deserializeSnapshotUserConfigurationRedactedDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
