// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.DashboardError
import aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions
import aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.sdk.kotlin.services.quicksight.model.ResourceStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeDashboardDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDashboardDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDashboardDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDashboardDefinitionError(context, call, payload)
        }
        val builder = DescribeDashboardDefinitionResponse.Builder()

        if (payload != null) {
            deserializeDescribeDashboardDefinitionOperationBody(builder, payload)
        }
        builder.status = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDashboardDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceExistsException" -> ResourceExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedUserEditionException" -> UnsupportedUserEditionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDashboardDefinitionOperationBody(builder: DescribeDashboardDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DashboardId"))
    val DASHBOARDPUBLISHOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DashboardPublishOptions"))
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Definition"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val RESOURCESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ResourceStatus"))
    val THEMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ThemeArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDID_DESCRIPTOR)
        field(DASHBOARDPUBLISHOPTIONS_DESCRIPTOR)
        field(DEFINITION_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(RESOURCESTATUS_DESCRIPTOR)
        field(THEMEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                DASHBOARDPUBLISHOPTIONS_DESCRIPTOR.index -> builder.dashboardPublishOptions = deserializeDashboardPublishOptionsDocument(deserializer)
                DEFINITION_DESCRIPTOR.index -> builder.definition = deserializeDashboardVersionDefinitionDocument(deserializer)
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<DashboardError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDashboardErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                RESOURCESTATUS_DESCRIPTOR.index -> builder.resourceStatus = deserializeString().let { ResourceStatus.fromValue(it) }
                THEMEARN_DESCRIPTOR.index -> builder.themeArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
