// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportFailureAction
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobError
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverrideParameters
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverridePermissions
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverrideTags
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobOverrideValidationStrategy
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobStatus
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobWarning
import aws.sdk.kotlin.services.quicksight.model.AssetBundleImportSourceDescription
import aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleImportJobResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeAssetBundleImportJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetBundleImportJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetBundleImportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetBundleImportJobError(context, call, payload)
        }
        val builder = DescribeAssetBundleImportJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetBundleImportJobOperationBody(builder, payload)
        }
        builder.status = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetBundleImportJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedUserEditionException" -> UnsupportedUserEditionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetBundleImportJobOperationBody(builder: DescribeAssetBundleImportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ASSETBUNDLEIMPORTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssetBundleImportJobId"))
    val ASSETBUNDLEIMPORTSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AssetBundleImportSource"))
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AwsAccountId"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val FAILUREACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FailureAction"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val OVERRIDEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverrideParameters"))
    val OVERRIDEPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverridePermissions"))
    val OVERRIDETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverrideTags"))
    val OVERRIDEVALIDATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverrideValidationStrategy"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val ROLLBACKERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RollbackErrors"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ASSETBUNDLEIMPORTJOBID_DESCRIPTOR)
        field(ASSETBUNDLEIMPORTSOURCE_DESCRIPTOR)
        field(AWSACCOUNTID_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
        field(FAILUREACTION_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(OVERRIDEPARAMETERS_DESCRIPTOR)
        field(OVERRIDEPERMISSIONS_DESCRIPTOR)
        field(OVERRIDETAGS_DESCRIPTOR)
        field(OVERRIDEVALIDATIONSTRATEGY_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(ROLLBACKERRORS_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ASSETBUNDLEIMPORTJOBID_DESCRIPTOR.index -> builder.assetBundleImportJobId = deserializeString()
                ASSETBUNDLEIMPORTSOURCE_DESCRIPTOR.index -> builder.assetBundleImportSource = deserializeAssetBundleImportSourceDescriptionDocument(deserializer)
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetBundleImportJobError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetBundleImportJobErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILUREACTION_DESCRIPTOR.index -> builder.failureAction = deserializeString().let { AssetBundleImportFailureAction.fromValue(it) }
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { AssetBundleImportJobStatus.fromValue(it) }
                OVERRIDEPARAMETERS_DESCRIPTOR.index -> builder.overrideParameters = deserializeAssetBundleImportJobOverrideParametersDocument(deserializer)
                OVERRIDEPERMISSIONS_DESCRIPTOR.index -> builder.overridePermissions = deserializeAssetBundleImportJobOverridePermissionsDocument(deserializer)
                OVERRIDETAGS_DESCRIPTOR.index -> builder.overrideTags = deserializeAssetBundleImportJobOverrideTagsDocument(deserializer)
                OVERRIDEVALIDATIONSTRATEGY_DESCRIPTOR.index -> builder.overrideValidationStrategy = deserializeAssetBundleImportJobOverrideValidationStrategyDocument(deserializer)
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                ROLLBACKERRORS_DESCRIPTOR.index -> builder.rollbackErrors =
                    deserializer.deserializeList(ROLLBACKERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetBundleImportJobError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetBundleImportJobErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetBundleImportJobWarning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetBundleImportJobWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
