// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration
import aws.sdk.kotlin.services.quicksight.model.AssetBundleExportFormat
import aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobError
import aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobStatus
import aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobValidationStrategy
import aws.sdk.kotlin.services.quicksight.model.AssetBundleExportJobWarning
import aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobResponse
import aws.sdk.kotlin.services.quicksight.model.IncludeFolderMembers
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeAssetBundleExportJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAssetBundleExportJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAssetBundleExportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAssetBundleExportJobError(context, call, payload)
        }
        val builder = DescribeAssetBundleExportJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeAssetBundleExportJobOperationBody(builder, payload)
        }
        builder.status = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAssetBundleExportJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedUserEditionException" -> UnsupportedUserEditionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAssetBundleExportJobOperationBody(builder: DescribeAssetBundleExportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ASSETBUNDLEEXPORTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssetBundleExportJobId"))
    val AWSACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AwsAccountId"))
    val CLOUDFORMATIONOVERRIDEPROPERTYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CloudFormationOverridePropertyConfiguration"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val DOWNLOADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DownloadUrl"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val EXPORTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ExportFormat"))
    val INCLUDEALLDEPENDENCIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeAllDependencies"))
    val INCLUDEFOLDERMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("IncludeFolderMembers"))
    val INCLUDEFOLDERMEMBERSHIPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeFolderMemberships"))
    val INCLUDEPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludePermissions"))
    val INCLUDETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeTags"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val RESOURCEARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceArns"))
    val VALIDATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationStrategy"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ASSETBUNDLEEXPORTJOBID_DESCRIPTOR)
        field(AWSACCOUNTID_DESCRIPTOR)
        field(CLOUDFORMATIONOVERRIDEPROPERTYCONFIGURATION_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(DOWNLOADURL_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
        field(EXPORTFORMAT_DESCRIPTOR)
        field(INCLUDEALLDEPENDENCIES_DESCRIPTOR)
        field(INCLUDEFOLDERMEMBERS_DESCRIPTOR)
        field(INCLUDEFOLDERMEMBERSHIPS_DESCRIPTOR)
        field(INCLUDEPERMISSIONS_DESCRIPTOR)
        field(INCLUDETAGS_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(RESOURCEARNS_DESCRIPTOR)
        field(VALIDATIONSTRATEGY_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ASSETBUNDLEEXPORTJOBID_DESCRIPTOR.index -> builder.assetBundleExportJobId = deserializeString()
                AWSACCOUNTID_DESCRIPTOR.index -> builder.awsAccountId = deserializeString()
                CLOUDFORMATIONOVERRIDEPROPERTYCONFIGURATION_DESCRIPTOR.index -> builder.cloudFormationOverridePropertyConfiguration = deserializeAssetBundleCloudFormationOverridePropertyConfigurationDocument(deserializer)
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DOWNLOADURL_DESCRIPTOR.index -> builder.downloadUrl = deserializeString()
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetBundleExportJobError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetBundleExportJobErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EXPORTFORMAT_DESCRIPTOR.index -> builder.exportFormat = deserializeString().let { AssetBundleExportFormat.fromValue(it) }
                INCLUDEALLDEPENDENCIES_DESCRIPTOR.index -> builder.includeAllDependencies = deserializeBoolean()
                INCLUDEFOLDERMEMBERS_DESCRIPTOR.index -> builder.includeFolderMembers = deserializeString().let { IncludeFolderMembers.fromValue(it) }
                INCLUDEFOLDERMEMBERSHIPS_DESCRIPTOR.index -> builder.includeFolderMemberships = deserializeBoolean()
                INCLUDEPERMISSIONS_DESCRIPTOR.index -> builder.includePermissions = deserializeBoolean()
                INCLUDETAGS_DESCRIPTOR.index -> builder.includeTags = deserializeBoolean()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { AssetBundleExportJobStatus.fromValue(it) }
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                RESOURCEARNS_DESCRIPTOR.index -> builder.resourceArns =
                    deserializer.deserializeList(RESOURCEARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALIDATIONSTRATEGY_DESCRIPTOR.index -> builder.validationStrategy = deserializeAssetBundleExportJobValidationStrategyDocument(deserializer)
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssetBundleExportJobWarning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssetBundleExportJobWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
