// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteDataSetOperationDeserializer: HttpDeserializer.NonStreaming<DeleteDataSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteDataSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteDataSetError(context, call, payload)
        }
        val builder = DeleteDataSetResponse.Builder()

        if (payload != null) {
            deserializeDeleteDataSetOperationBody(builder, payload)
        }
        builder.status = response.status.value
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteDataSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteDataSetOperationBody(builder: DeleteDataSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val DATASETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSetId"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(DATASETID_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                DATASETID_DESCRIPTOR.index -> builder.dataSetId = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
