// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.CreateTopicRequest
import aws.sdk.kotlin.services.quicksight.model.CustomInstructions
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.sdk.kotlin.services.quicksight.model.TopicDetails
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateTopicOperationSerializer: HttpSerializer.NonStreaming<CreateTopicRequest> {
    override fun serialize(context: ExecutionContext, input: CreateTopicRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("topics"))
            }
        }

        val payload = serializeCreateTopicOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateTopicOperationBody(context: ExecutionContext, input: CreateTopicRequest): ByteArray {
    val serializer = JsonSerializer()
    val CUSTOMINSTRUCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CustomInstructions"))
    val FOLDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FolderArns"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TOPIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Topic"))
    val TOPICID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TopicId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMINSTRUCTIONS_DESCRIPTOR)
        field(FOLDERARNS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TOPIC_DESCRIPTOR)
        field(TOPICID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.customInstructions?.let { field(CUSTOMINSTRUCTIONS_DESCRIPTOR, it, ::serializeCustomInstructionsDocument) }
        if (input.folderArns != null) {
            listField(FOLDERARNS_DESCRIPTOR) {
                for (el0 in input.folderArns) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.topic?.let { field(TOPIC_DESCRIPTOR, it, ::serializeTopicDetailsDocument) }
        input.topicId?.let { field(TOPICID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
