// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.CreateFolderRequest
import aws.sdk.kotlin.services.quicksight.model.FolderType
import aws.sdk.kotlin.services.quicksight.model.ResourcePermission
import aws.sdk.kotlin.services.quicksight.model.SharingModel
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateFolderOperationSerializer: HttpSerializer.NonStreaming<CreateFolderRequest> {
    override fun serialize(context: ExecutionContext, input: CreateFolderRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.folderId) { "folderId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("folders"))
                add(PercentEncoding.SmithyLabel.encode(input.folderId))
            }
        }

        val payload = serializeCreateFolderOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFolderOperationBody(context: ExecutionContext, input: CreateFolderRequest): ByteArray {
    val serializer = JsonSerializer()
    val FOLDERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FolderType"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARENTFOLDERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ParentFolderArn"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val SHARINGMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SharingModel"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FOLDERTYPE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARENTFOLDERARN_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(SHARINGMODEL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.folderType?.let { field(FOLDERTYPE_DESCRIPTOR, it.value) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parentFolderArn?.let { field(PARENTFOLDERARN_DESCRIPTOR, it) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourcePermissionDocument))
                }
            }
        }
        input.sharingModel?.let { field(SHARINGMODEL_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
