// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials
import aws.sdk.kotlin.services.quicksight.model.DataSourceParameters
import aws.sdk.kotlin.services.quicksight.model.DataSourceType
import aws.sdk.kotlin.services.quicksight.model.ResourcePermission
import aws.sdk.kotlin.services.quicksight.model.SslProperties
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDataSourceOperationSerializer: HttpSerializer.NonStreaming<CreateDataSourceRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDataSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("data-sources"))
            }
        }

        val payload = serializeCreateDataSourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDataSourceOperationBody(context: ExecutionContext, input: CreateDataSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Credentials"))
    val DATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSourceId"))
    val DATASOURCEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSourceParameters"))
    val FOLDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FolderArns"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val SSLPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SslProperties"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val VPCCONNECTIONPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConnectionProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIALS_DESCRIPTOR)
        field(DATASOURCEID_DESCRIPTOR)
        field(DATASOURCEPARAMETERS_DESCRIPTOR)
        field(FOLDERARNS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(SSLPROPERTIES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VPCCONNECTIONPROPERTIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.credentials?.let { field(CREDENTIALS_DESCRIPTOR, it, ::serializeDataSourceCredentialsDocument) }
        input.dataSourceId?.let { field(DATASOURCEID_DESCRIPTOR, it) }
        input.dataSourceParameters?.let { field(DATASOURCEPARAMETERS_DESCRIPTOR, it, ::serializeDataSourceParametersDocument) }
        if (input.folderArns != null) {
            listField(FOLDERARNS_DESCRIPTOR) {
                for (el0 in input.folderArns) {
                    serializeString(el0)
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourcePermissionDocument))
                }
            }
        }
        input.sslProperties?.let { field(SSLPROPERTIES_DESCRIPTOR, it, ::serializeSslPropertiesDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
        input.vpcConnectionProperties?.let { field(VPCCONNECTIONPROPERTIES_DESCRIPTOR, it, ::serializeVpcConnectionPropertiesDocument) }
    }
    return serializer.toByteArray()
}
