// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.ColumnGroup
import aws.sdk.kotlin.services.quicksight.model.ColumnLevelPermissionRule
import aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.DataSetImportMode
import aws.sdk.kotlin.services.quicksight.model.DataSetUsageConfiguration
import aws.sdk.kotlin.services.quicksight.model.DataSetUseAs
import aws.sdk.kotlin.services.quicksight.model.DatasetParameter
import aws.sdk.kotlin.services.quicksight.model.FieldFolder
import aws.sdk.kotlin.services.quicksight.model.LogicalTable
import aws.sdk.kotlin.services.quicksight.model.PerformanceConfiguration
import aws.sdk.kotlin.services.quicksight.model.PhysicalTable
import aws.sdk.kotlin.services.quicksight.model.ResourcePermission
import aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet
import aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionTagConfiguration
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDataSetOperationSerializer: HttpSerializer.NonStreaming<CreateDataSetRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDataSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("data-sets"))
            }
        }

        val payload = serializeCreateDataSetOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDataSetOperationBody(context: ExecutionContext, input: CreateDataSetRequest): ByteArray {
    val serializer = JsonSerializer()
    val COLUMNGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ColumnGroups"))
    val COLUMNLEVELPERMISSIONRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ColumnLevelPermissionRules"))
    val DATASETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSetId"))
    val DATASETUSAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSetUsageConfiguration"))
    val DATASETPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DatasetParameters"))
    val FIELDFOLDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("FieldFolders"))
    val FOLDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FolderArns"))
    val IMPORTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ImportMode"))
    val LOGICALTABLEMAP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("LogicalTableMap"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERFORMANCECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PerformanceConfiguration"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val PHYSICALTABLEMAP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PhysicalTableMap"))
    val ROWLEVELPERMISSIONDATASET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RowLevelPermissionDataSet"))
    val ROWLEVELPERMISSIONTAGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RowLevelPermissionTagConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val USEAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UseAs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLUMNGROUPS_DESCRIPTOR)
        field(COLUMNLEVELPERMISSIONRULES_DESCRIPTOR)
        field(DATASETID_DESCRIPTOR)
        field(DATASETUSAGECONFIGURATION_DESCRIPTOR)
        field(DATASETPARAMETERS_DESCRIPTOR)
        field(FIELDFOLDERS_DESCRIPTOR)
        field(FOLDERARNS_DESCRIPTOR)
        field(IMPORTMODE_DESCRIPTOR)
        field(LOGICALTABLEMAP_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERFORMANCECONFIGURATION_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(PHYSICALTABLEMAP_DESCRIPTOR)
        field(ROWLEVELPERMISSIONDATASET_DESCRIPTOR)
        field(ROWLEVELPERMISSIONTAGCONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USEAS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.columnGroups != null) {
            listField(COLUMNGROUPS_DESCRIPTOR) {
                for (el0 in input.columnGroups) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeColumnGroupDocument))
                }
            }
        }
        if (input.columnLevelPermissionRules != null) {
            listField(COLUMNLEVELPERMISSIONRULES_DESCRIPTOR) {
                for (el0 in input.columnLevelPermissionRules) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeColumnLevelPermissionRuleDocument))
                }
            }
        }
        input.dataSetId?.let { field(DATASETID_DESCRIPTOR, it) }
        input.dataSetUsageConfiguration?.let { field(DATASETUSAGECONFIGURATION_DESCRIPTOR, it, ::serializeDataSetUsageConfigurationDocument) }
        if (input.datasetParameters != null) {
            listField(DATASETPARAMETERS_DESCRIPTOR) {
                for (el0 in input.datasetParameters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDatasetParameterDocument))
                }
            }
        }
        if (input.fieldFolders != null) {
            mapField(FIELDFOLDERS_DESCRIPTOR) {
                input.fieldFolders.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeFieldFolderDocument)) }
            }
        }
        if (input.folderArns != null) {
            listField(FOLDERARNS_DESCRIPTOR) {
                for (el0 in input.folderArns) {
                    serializeString(el0)
                }
            }
        }
        input.importMode?.let { field(IMPORTMODE_DESCRIPTOR, it.value) }
        if (input.logicalTableMap != null) {
            mapField(LOGICALTABLEMAP_DESCRIPTOR) {
                input.logicalTableMap.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeLogicalTableDocument)) }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.performanceConfiguration?.let { field(PERFORMANCECONFIGURATION_DESCRIPTOR, it, ::serializePerformanceConfigurationDocument) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourcePermissionDocument))
                }
            }
        }
        if (input.physicalTableMap != null) {
            mapField(PHYSICALTABLEMAP_DESCRIPTOR) {
                input.physicalTableMap.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializePhysicalTableDocument)) }
            }
        }
        input.rowLevelPermissionDataSet?.let { field(ROWLEVELPERMISSIONDATASET_DESCRIPTOR, it, ::serializeRowLevelPermissionDataSetDocument) }
        input.rowLevelPermissionTagConfiguration?.let { field(ROWLEVELPERMISSIONTAGCONFIGURATION_DESCRIPTOR, it, ::serializeRowLevelPermissionTagConfigurationDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.useAs?.let { field(USEAS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
