// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions
import aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity
import aws.sdk.kotlin.services.quicksight.model.DashboardVersionDefinition
import aws.sdk.kotlin.services.quicksight.model.LinkSharingConfiguration
import aws.sdk.kotlin.services.quicksight.model.Parameters
import aws.sdk.kotlin.services.quicksight.model.ResourcePermission
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.sdk.kotlin.services.quicksight.model.ValidationStrategy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDashboardOperationSerializer: HttpSerializer.NonStreaming<CreateDashboardRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDashboardRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.dashboardId) { "dashboardId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("dashboards"))
                add(PercentEncoding.SmithyLabel.encode(input.dashboardId))
            }
        }

        val payload = serializeCreateDashboardOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDashboardOperationBody(context: ExecutionContext, input: CreateDashboardRequest): ByteArray {
    val serializer = JsonSerializer()
    val DASHBOARDPUBLISHOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DashboardPublishOptions"))
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Definition"))
    val FOLDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FolderArns"))
    val LINKENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LinkEntities"))
    val LINKSHARINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LinkSharingConfiguration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Parameters"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val SOURCEENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceEntity"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val THEMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ThemeArn"))
    val VALIDATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationStrategy"))
    val VERSIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDPUBLISHOPTIONS_DESCRIPTOR)
        field(DEFINITION_DESCRIPTOR)
        field(FOLDERARNS_DESCRIPTOR)
        field(LINKENTITIES_DESCRIPTOR)
        field(LINKSHARINGCONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(SOURCEENTITY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(THEMEARN_DESCRIPTOR)
        field(VALIDATIONSTRATEGY_DESCRIPTOR)
        field(VERSIONDESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dashboardPublishOptions?.let { field(DASHBOARDPUBLISHOPTIONS_DESCRIPTOR, it, ::serializeDashboardPublishOptionsDocument) }
        input.definition?.let { field(DEFINITION_DESCRIPTOR, it, ::serializeDashboardVersionDefinitionDocument) }
        if (input.folderArns != null) {
            listField(FOLDERARNS_DESCRIPTOR) {
                for (el0 in input.folderArns) {
                    serializeString(el0)
                }
            }
        }
        if (input.linkEntities != null) {
            listField(LINKENTITIES_DESCRIPTOR) {
                for (el0 in input.linkEntities) {
                    serializeString(el0)
                }
            }
        }
        input.linkSharingConfiguration?.let { field(LINKSHARINGCONFIGURATION_DESCRIPTOR, it, ::serializeLinkSharingConfigurationDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parameters?.let { field(PARAMETERS_DESCRIPTOR, it, ::serializeParametersDocument) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourcePermissionDocument))
                }
            }
        }
        input.sourceEntity?.let { field(SOURCEENTITY_DESCRIPTOR, it, ::serializeDashboardSourceEntityDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.themeArn?.let { field(THEMEARN_DESCRIPTOR, it) }
        input.validationStrategy?.let { field(VALIDATIONSTRATEGY_DESCRIPTOR, it, ::serializeValidationStrategyDocument) }
        input.versionDescription?.let { field(VERSIONDESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
