// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition
import aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity
import aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.Parameters
import aws.sdk.kotlin.services.quicksight.model.ResourcePermission
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.sdk.kotlin.services.quicksight.model.ValidationStrategy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAnalysisOperationSerializer: HttpSerializer.NonStreaming<CreateAnalysisRequest> {
    override fun serialize(context: ExecutionContext, input: CreateAnalysisRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.analysisId) { "analysisId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("analyses"))
                add(PercentEncoding.SmithyLabel.encode(input.analysisId))
            }
        }

        val payload = serializeCreateAnalysisOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAnalysisOperationBody(context: ExecutionContext, input: CreateAnalysisRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Definition"))
    val FOLDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FolderArns"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Parameters"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val SOURCEENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceEntity"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val THEMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ThemeArn"))
    val VALIDATIONSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidationStrategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFINITION_DESCRIPTOR)
        field(FOLDERARNS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(SOURCEENTITY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(THEMEARN_DESCRIPTOR)
        field(VALIDATIONSTRATEGY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.definition?.let { field(DEFINITION_DESCRIPTOR, it, ::serializeAnalysisDefinitionDocument) }
        if (input.folderArns != null) {
            listField(FOLDERARNS_DESCRIPTOR) {
                for (el0 in input.folderArns) {
                    serializeString(el0)
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parameters?.let { field(PARAMETERS_DESCRIPTOR, it, ::serializeParametersDocument) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourcePermissionDocument))
                }
            }
        }
        input.sourceEntity?.let { field(SOURCEENTITY_DESCRIPTOR, it, ::serializeAnalysisSourceEntityDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.themeArn?.let { field(THEMEARN_DESCRIPTOR, it) }
        input.validationStrategy?.let { field(VALIDATIONSTRATEGY_DESCRIPTOR, it, ::serializeValidationStrategyDocument) }
    }
    return serializer.toByteArray()
}
