// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides the forecast to meet the target for a particular date range.
 */
public class WhatIfRangeScenario private constructor(builder: Builder) {
    /**
     * The end date in the date range that you need the forecast results for.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endDate) { "A non-null value must be provided for endDate" }
    /**
     * The start date in the date range that you need the forecast results for.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startDate) { "A non-null value must be provided for startDate" }
    /**
     * The target value that you want to meet for the provided date range.
     */
    public val value: kotlin.Double = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.WhatIfRangeScenario = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WhatIfRangeScenario(")
        append("endDate=$endDate,")
        append("startDate=$startDate,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate.hashCode()
        result = 31 * result + (startDate.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WhatIfRangeScenario

        if (endDate != other.endDate) return false
        if (startDate != other.startDate) return false
        if (!(value?.equals(other.value) ?: (other.value == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.WhatIfRangeScenario = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end date in the date range that you need the forecast results for.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start date in the date range that you need the forecast results for.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The target value that you want to meet for the provided date range.
         */
        public var value: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.WhatIfRangeScenario) : this() {
            this.endDate = x.endDate
            this.startDate = x.startDate
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.WhatIfRangeScenario = WhatIfRangeScenario(this)

        internal fun correctErrors(): Builder {
            if (endDate == null) endDate = Instant.fromEpochSeconds(0)
            if (startDate == null) startDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
