// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary metadata that describes a VPC connection.
 */
public class VpcConnectionSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the VPC connection.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The availability status of the VPC connection.
     */
    public val availabilityStatus: aws.sdk.kotlin.services.quicksight.model.VpcConnectionAvailabilityStatus? = builder.availabilityStatus
    /**
     * The time that the VPC connection was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    public val dnsResolvers: List<String>? = builder.dnsResolvers
    /**
     * The time that the VPC connection was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The display name for the VPC connection.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of network interfaces.
     */
    public val networkInterfaces: List<NetworkInterface>? = builder.networkInterfaces
    /**
     * The ARN of the IAM role associated with the VPC connection.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon EC2 security group IDs associated with the VPC connection.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The status of the VPC connection.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.VpcConnectionResourceStatus? = builder.status
    /**
     * The ID of the VPC connection that you're creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.
     */
    public val vpcConnectionId: kotlin.String? = builder.vpcConnectionId
    /**
     * The Amazon EC2 VPC ID associated with the VPC connection.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.VpcConnectionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConnectionSummary(")
        append("arn=$arn,")
        append("availabilityStatus=$availabilityStatus,")
        append("createdTime=$createdTime,")
        append("dnsResolvers=$dnsResolvers,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("networkInterfaces=$networkInterfaces,")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("status=$status,")
        append("vpcConnectionId=$vpcConnectionId,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (availabilityStatus?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dnsResolvers?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectionId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConnectionSummary

        if (arn != other.arn) return false
        if (availabilityStatus != other.availabilityStatus) return false
        if (createdTime != other.createdTime) return false
        if (dnsResolvers != other.dnsResolvers) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (status != other.status) return false
        if (vpcConnectionId != other.vpcConnectionId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.VpcConnectionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the VPC connection.
         */
        public var arn: kotlin.String? = null
        /**
         * The availability status of the VPC connection.
         */
        public var availabilityStatus: aws.sdk.kotlin.services.quicksight.model.VpcConnectionAvailabilityStatus? = null
        /**
         * The time that the VPC connection was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of IP addresses of DNS resolver endpoints for the VPC connection.
         */
        public var dnsResolvers: List<String>? = null
        /**
         * The time that the VPC connection was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The display name for the VPC connection.
         */
        public var name: kotlin.String? = null
        /**
         * A list of network interfaces.
         */
        public var networkInterfaces: List<NetworkInterface>? = null
        /**
         * The ARN of the IAM role associated with the VPC connection.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon EC2 security group IDs associated with the VPC connection.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The status of the VPC connection.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.VpcConnectionResourceStatus? = null
        /**
         * The ID of the VPC connection that you're creating. This ID is a unique identifier for each Amazon Web Services Region in an Amazon Web Services account.
         */
        public var vpcConnectionId: kotlin.String? = null
        /**
         * The Amazon EC2 VPC ID associated with the VPC connection.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.VpcConnectionSummary) : this() {
            this.arn = x.arn
            this.availabilityStatus = x.availabilityStatus
            this.createdTime = x.createdTime
            this.dnsResolvers = x.dnsResolvers
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.networkInterfaces = x.networkInterfaces
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.status = x.status
            this.vpcConnectionId = x.vpcConnectionId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.VpcConnectionSummary = VpcConnectionSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
