// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A custom action defined on a visual.
 */
public class VisualCustomAction private constructor(builder: Builder) {
    /**
     * A list of `VisualCustomActionOperations`.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     */
    public val actionOperations: List<VisualCustomActionOperation> = requireNotNull(builder.actionOperations) { "A non-null value must be provided for actionOperations" }
    /**
     * The ID of the `VisualCustomAction`.
     */
    public val customActionId: kotlin.String = requireNotNull(builder.customActionId) { "A non-null value must be provided for customActionId" }
    /**
     * The name of the `VisualCustomAction`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the `VisualCustomAction`.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.WidgetStatus? = builder.status
    /**
     * The trigger of the `VisualCustomAction`.
     *
     * Valid values are defined as follows:
     * + `DATA_POINT_CLICK`: Initiates a custom action by a left pointer click on a data point.
     * + `DATA_POINT_MENU`: Initiates a custom action by right pointer click from the menu.
     */
    public val trigger: aws.sdk.kotlin.services.quicksight.model.VisualCustomActionTrigger = requireNotNull(builder.trigger) { "A non-null value must be provided for trigger" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.VisualCustomAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VisualCustomAction(")
        append("actionOperations=$actionOperations,")
        append("customActionId=$customActionId,")
        append("name=$name,")
        append("status=$status,")
        append("trigger=$trigger")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionOperations.hashCode()
        result = 31 * result + (customActionId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trigger.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VisualCustomAction

        if (actionOperations != other.actionOperations) return false
        if (customActionId != other.customActionId) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (trigger != other.trigger) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.VisualCustomAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of `VisualCustomActionOperations`.
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         */
        public var actionOperations: List<VisualCustomActionOperation>? = null
        /**
         * The ID of the `VisualCustomAction`.
         */
        public var customActionId: kotlin.String? = null
        /**
         * The name of the `VisualCustomAction`.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the `VisualCustomAction`.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.WidgetStatus? = null
        /**
         * The trigger of the `VisualCustomAction`.
         *
         * Valid values are defined as follows:
         * + `DATA_POINT_CLICK`: Initiates a custom action by a left pointer click on a data point.
         * + `DATA_POINT_MENU`: Initiates a custom action by right pointer click from the menu.
         */
        public var trigger: aws.sdk.kotlin.services.quicksight.model.VisualCustomActionTrigger? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.VisualCustomAction) : this() {
            this.actionOperations = x.actionOperations
            this.customActionId = x.customActionId
            this.name = x.name
            this.status = x.status
            this.trigger = x.trigger
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.VisualCustomAction = VisualCustomAction(this)

        internal fun correctErrors(): Builder {
            if (actionOperations == null) actionOperations = emptyList()
            if (customActionId == null) customActionId = ""
            if (name == null) name = ""
            if (trigger == null) trigger = VisualCustomActionTrigger.SdkUnknown("no value provided")
            return this
        }
    }
}
