// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateThemeRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that contains the theme that you're updating.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.
     */
    public val baseThemeId: kotlin.String? = builder.baseThemeId
    /**
     * The theme configuration, which contains the theme display properties.
     */
    public val configuration: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration? = builder.configuration
    /**
     * The name for the theme.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID for the theme.
     */
    public val themeId: kotlin.String? = builder.themeId
    /**
     * A description of the theme version that you're updating Every time that you call `UpdateTheme`, you create a new version of the theme. Each version of the theme maintains a description of the version in `VersionDescription`.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateThemeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateThemeRequest(")
        append("awsAccountId=$awsAccountId,")
        append("baseThemeId=$baseThemeId,")
        append("configuration=$configuration,")
        append("name=$name,")
        append("themeId=$themeId,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (baseThemeId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (themeId?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateThemeRequest

        if (awsAccountId != other.awsAccountId) return false
        if (baseThemeId != other.baseThemeId) return false
        if (configuration != other.configuration) return false
        if (name != other.name) return false
        if (themeId != other.themeId) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateThemeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that contains the theme that you're updating.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.
         */
        public var baseThemeId: kotlin.String? = null
        /**
         * The theme configuration, which contains the theme display properties.
         */
        public var configuration: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration? = null
        /**
         * The name for the theme.
         */
        public var name: kotlin.String? = null
        /**
         * The ID for the theme.
         */
        public var themeId: kotlin.String? = null
        /**
         * A description of the theme version that you're updating Every time that you call `UpdateTheme`, you create a new version of the theme. Each version of the theme maintains a description of the version in `VersionDescription`.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateThemeRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.baseThemeId = x.baseThemeId
            this.configuration = x.configuration
            this.name = x.name
            this.themeId = x.themeId
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateThemeRequest = UpdateThemeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
