// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateTemplateRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that contains the template that you're updating.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The definition of a template.
     *
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public val definition: aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition? = builder.definition
    /**
     * The name for the template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The entity that you are using as a source when you update the template. In `SourceEntity`, you specify the type of object you're using as source: `SourceTemplate` for a template or `SourceAnalysis` for an analysis. Both of these require an Amazon Resource Name (ARN). For `SourceTemplate`, specify the ARN of the source template. For `SourceAnalysis`, specify the ARN of the source analysis. The `SourceTemplate` ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;.
     *
     * Use the `DataSetReferences` entity within `SourceTemplate` or `SourceAnalysis` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    public val sourceEntity: aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity? = builder.sourceEntity
    /**
     * The ID for the template.
     */
    public val templateId: kotlin.String? = builder.templateId
    /**
     * The option to relax the validation needed to update a template with definition objects. This skips the validation step for specific errors.
     */
    public val validationStrategy: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy? = builder.validationStrategy
    /**
     * A description of the current template version that is being updated. Every time you call `UpdateTemplate`, you create a new version of the template. Each version of the template maintains a description of the version in the `VersionDescription` field.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTemplateRequest(")
        append("awsAccountId=$awsAccountId,")
        append("definition=$definition,")
        append("name=$name,")
        append("sourceEntity=$sourceEntity,")
        append("templateId=$templateId,")
        append("validationStrategy=$validationStrategy,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceEntity?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        result = 31 * result + (validationStrategy?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTemplateRequest

        if (awsAccountId != other.awsAccountId) return false
        if (definition != other.definition) return false
        if (name != other.name) return false
        if (sourceEntity != other.sourceEntity) return false
        if (templateId != other.templateId) return false
        if (validationStrategy != other.validationStrategy) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that contains the template that you're updating.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The definition of a template.
         *
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         */
        public var definition: aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition? = null
        /**
         * The name for the template.
         */
        public var name: kotlin.String? = null
        /**
         * The entity that you are using as a source when you update the template. In `SourceEntity`, you specify the type of object you're using as source: `SourceTemplate` for a template or `SourceAnalysis` for an analysis. Both of these require an Amazon Resource Name (ARN). For `SourceTemplate`, specify the ARN of the source template. For `SourceAnalysis`, specify the ARN of the source analysis. The `SourceTemplate` ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;.
         *
         * Use the `DataSetReferences` entity within `SourceTemplate` or `SourceAnalysis` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         */
        public var sourceEntity: aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity? = null
        /**
         * The ID for the template.
         */
        public var templateId: kotlin.String? = null
        /**
         * The option to relax the validation needed to update a template with definition objects. This skips the validation step for specific errors.
         */
        public var validationStrategy: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy? = null
        /**
         * A description of the current template version that is being updated. Every time you call `UpdateTemplate`, you create a new version of the template. Each version of the template maintains a description of the version in the `VersionDescription` field.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateTemplateRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.definition = x.definition
            this.name = x.name
            this.sourceEntity = x.sourceEntity
            this.templateId = x.templateId
            this.validationStrategy = x.validationStrategy
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateTemplateRequest = UpdateTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity] inside the given [block]
         */
        public fun sourceEntity(block: aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity.Builder.() -> kotlin.Unit) {
            this.sourceEntity = aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ValidationStrategy] inside the given [block]
         */
        public fun validationStrategy(block: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy.Builder.() -> kotlin.Unit) {
            this.validationStrategy = aws.sdk.kotlin.services.quicksight.model.ValidationStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
