// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateIamPolicyAssignmentResponse private constructor(builder: Builder) {
    /**
     * The ID of the assignment.
     */
    public val assignmentId: kotlin.String? = builder.assignmentId
    /**
     * The name of the assignment or rule.
     */
    public val assignmentName: kotlin.String? = builder.assignmentName
    /**
     * The status of the assignment. Possible values are as follows:
     * + `ENABLED` - Anything specified in this assignment is used when creating the data source.
     * + `DISABLED` - This assignment isn't used when creating the data source.
     * + `DRAFT` - This assignment is an unfinished draft and isn't used when creating the data source.
     */
    public val assignmentStatus: aws.sdk.kotlin.services.quicksight.model.AssignmentStatus? = builder.assignmentStatus
    /**
     * The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.
     */
    public val identities: Map<String, List<String>>? = builder.identities
    /**
     * The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The Amazon Web Services request ID for this operation.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The HTTP status of the request.
     */
    public val status: kotlin.Int = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIamPolicyAssignmentResponse(")
        append("assignmentId=$assignmentId,")
        append("assignmentName=$assignmentName,")
        append("assignmentStatus=$assignmentStatus,")
        append("identities=$identities,")
        append("policyArn=$policyArn,")
        append("requestId=$requestId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignmentId?.hashCode() ?: 0
        result = 31 * result + (assignmentName?.hashCode() ?: 0)
        result = 31 * result + (assignmentStatus?.hashCode() ?: 0)
        result = 31 * result + (identities?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (status)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIamPolicyAssignmentResponse

        if (assignmentId != other.assignmentId) return false
        if (assignmentName != other.assignmentName) return false
        if (assignmentStatus != other.assignmentStatus) return false
        if (identities != other.identities) return false
        if (policyArn != other.policyArn) return false
        if (requestId != other.requestId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the assignment.
         */
        public var assignmentId: kotlin.String? = null
        /**
         * The name of the assignment or rule.
         */
        public var assignmentName: kotlin.String? = null
        /**
         * The status of the assignment. Possible values are as follows:
         * + `ENABLED` - Anything specified in this assignment is used when creating the data source.
         * + `DISABLED` - This assignment isn't used when creating the data source.
         * + `DRAFT` - This assignment is an unfinished draft and isn't used when creating the data source.
         */
        public var assignmentStatus: aws.sdk.kotlin.services.quicksight.model.AssignmentStatus? = null
        /**
         * The Amazon QuickSight users, groups, or both that the IAM policy is assigned to.
         */
        public var identities: Map<String, List<String>>? = null
        /**
         * The ARN for the IAM policy applied to the Amazon QuickSight users and groups specified in this assignment.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The Amazon Web Services request ID for this operation.
         */
        public var requestId: kotlin.String? = null
        /**
         * The HTTP status of the request.
         */
        public var status: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentResponse) : this() {
            this.assignmentId = x.assignmentId
            this.assignmentName = x.assignmentName
            this.assignmentStatus = x.assignmentStatus
            this.identities = x.identities
            this.policyArn = x.policyArn
            this.requestId = x.requestId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentResponse = UpdateIamPolicyAssignmentResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
