// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAnalysisRequest private constructor(builder: Builder) {
    /**
     * The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
     */
    public val analysisId: kotlin.String? = builder.analysisId
    /**
     * The ID of the Amazon Web Services account that contains the analysis that you're updating.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The definition of an analysis.
     *
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public val definition: aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition? = builder.definition
    /**
     * A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values.
     */
    public val parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = builder.parameters
    /**
     * A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.
     */
    public val sourceEntity: aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity? = builder.sourceEntity
    /**
     * The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.
     */
    public val themeArn: kotlin.String? = builder.themeArn
    /**
     * The option to relax the validation needed to update an analysis with definition objects. This skips the validation step for specific errors.
     */
    public val validationStrategy: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy? = builder.validationStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAnalysisRequest(")
        append("analysisId=$analysisId,")
        append("awsAccountId=$awsAccountId,")
        append("definition=$definition,")
        append("name=$name,")
        append("parameters=$parameters,")
        append("sourceEntity=$sourceEntity,")
        append("themeArn=$themeArn,")
        append("validationStrategy=$validationStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisId?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (sourceEntity?.hashCode() ?: 0)
        result = 31 * result + (themeArn?.hashCode() ?: 0)
        result = 31 * result + (validationStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAnalysisRequest

        if (analysisId != other.analysisId) return false
        if (awsAccountId != other.awsAccountId) return false
        if (definition != other.definition) return false
        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (sourceEntity != other.sourceEntity) return false
        if (themeArn != other.themeArn) return false
        if (validationStrategy != other.validationStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
         */
        public var analysisId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that contains the analysis that you're updating.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The definition of an analysis.
         *
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         */
        public var definition: aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition? = null
        /**
         * A descriptive name for the analysis that you're updating. This name displays for the analysis in the Amazon QuickSight console.
         */
        public var name: kotlin.String? = null
        /**
         * The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values.
         */
        public var parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = null
        /**
         * A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.
         */
        public var sourceEntity: aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity? = null
        /**
         * The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.
         */
        public var themeArn: kotlin.String? = null
        /**
         * The option to relax the validation needed to update an analysis with definition objects. This skips the validation step for specific errors.
         */
        public var validationStrategy: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest) : this() {
            this.analysisId = x.analysisId
            this.awsAccountId = x.awsAccountId
            this.definition = x.definition
            this.name = x.name
            this.parameters = x.parameters
            this.sourceEntity = x.sourceEntity
            this.themeArn = x.themeArn
            this.validationStrategy = x.validationStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest = UpdateAnalysisRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition] inside the given [block]
         */
        public fun definition(block: aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.quicksight.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.quicksight.model.Parameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity] inside the given [block]
         */
        public fun sourceEntity(block: aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity.Builder.() -> kotlin.Unit) {
            this.sourceEntity = aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ValidationStrategy] inside the given [block]
         */
        public fun validationStrategy(block: aws.sdk.kotlin.services.quicksight.model.ValidationStrategy.Builder.() -> kotlin.Unit) {
            this.validationStrategy = aws.sdk.kotlin.services.quicksight.model.ValidationStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
