// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAccountSettingsRequest private constructor(builder: Builder) {
    /**
     * The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The default namespace for this Amazon Web Services account. Currently, the default is `default`. IAM users that register for the first time with Amazon QuickSight provide an email address that becomes associated with the default namespace.
     */
    public val defaultNamespace: kotlin.String? = builder.defaultNamespace
    /**
     * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.
     */
    public val notificationEmail: kotlin.String? = builder.notificationEmail
    /**
     * A boolean value that determines whether or not an Amazon QuickSight account can be deleted. A `True` value doesn't allow the account to be deleted and results in an error message if a user tries to make a `DeleteAccountSubscription` request. A `False` value will allow the account to be deleted.
     */
    public val terminationProtectionEnabled: kotlin.Boolean? = builder.terminationProtectionEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccountSettingsRequest(")
        append("awsAccountId=$awsAccountId,")
        append("defaultNamespace=$defaultNamespace,")
        append("notificationEmail=$notificationEmail,")
        append("terminationProtectionEnabled=$terminationProtectionEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (defaultNamespace?.hashCode() ?: 0)
        result = 31 * result + (notificationEmail?.hashCode() ?: 0)
        result = 31 * result + (terminationProtectionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAccountSettingsRequest

        if (awsAccountId != other.awsAccountId) return false
        if (defaultNamespace != other.defaultNamespace) return false
        if (notificationEmail != other.notificationEmail) return false
        if (terminationProtectionEnabled != other.terminationProtectionEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID for the Amazon Web Services account that contains the Amazon QuickSight settings that you want to list.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The default namespace for this Amazon Web Services account. Currently, the default is `default`. IAM users that register for the first time with Amazon QuickSight provide an email address that becomes associated with the default namespace.
         */
        public var defaultNamespace: kotlin.String? = null
        /**
         * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon Web Services account or Amazon QuickSight subscription.
         */
        public var notificationEmail: kotlin.String? = null
        /**
         * A boolean value that determines whether or not an Amazon QuickSight account can be deleted. A `True` value doesn't allow the account to be deleted and results in an error message if a user tries to make a `DeleteAccountSubscription` request. A `False` value will allow the account to be deleted.
         */
        public var terminationProtectionEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.defaultNamespace = x.defaultNamespace
            this.notificationEmail = x.notificationEmail
            this.terminationProtectionEnabled = x.terminationProtectionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsRequest = UpdateAccountSettingsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
