// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * This error indicates that you are calling an embedding operation in Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on the **Manage Amazon QuickSight** page.
 *
 * After capacity pricing is added, you can use the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> ` API operation with the `--identity-type ANONYMOUS` option.
 */
public class UnsupportedPricingPlanException private constructor(builder: Builder) : QuickSightException(builder.message) {

    /**
     * The Amazon Web Services request ID for this request.
     */
    public val requestId: kotlin.String? = builder.requestId

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UnsupportedPricingPlanException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UnsupportedPricingPlanException(")
        append("message=$message,")
        append("requestId=$requestId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UnsupportedPricingPlanException

        if (message != other.message) return false
        if (requestId != other.requestId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UnsupportedPricingPlanException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The Amazon Web Services request ID for this request.
         */
        public var requestId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UnsupportedPricingPlanException) : this() {
            this.message = x.message
            this.requestId = x.requestId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UnsupportedPricingPlanException = UnsupportedPricingPlanException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
