// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The theme colors that apply to UI and to charts, excluding data colors. The colors description is a hexadecimal color code that consists of six alphanumerical characters, prefixed with `#`, for example #37BFF5. For more information, see [Using Themes in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html) in the *Amazon QuickSight User Guide.*
 */
public class UiColorPalette private constructor(builder: Builder) {
    /**
     * This color is that applies to selected states and buttons.
     */
    public val accent: kotlin.String? = builder.accent
    /**
     * The foreground color that applies to any text or other elements that appear over the accent color.
     */
    public val accentForeground: kotlin.String? = builder.accentForeground
    /**
     * The color that applies to error messages.
     */
    public val danger: kotlin.String? = builder.danger
    /**
     * The foreground color that applies to any text or other elements that appear over the error color.
     */
    public val dangerForeground: kotlin.String? = builder.dangerForeground
    /**
     * The color that applies to the names of fields that are identified as dimensions.
     */
    public val dimension: kotlin.String? = builder.dimension
    /**
     * The foreground color that applies to any text or other elements that appear over the dimension color.
     */
    public val dimensionForeground: kotlin.String? = builder.dimensionForeground
    /**
     * The color that applies to the names of fields that are identified as measures.
     */
    public val measure: kotlin.String? = builder.measure
    /**
     * The foreground color that applies to any text or other elements that appear over the measure color.
     */
    public val measureForeground: kotlin.String? = builder.measureForeground
    /**
     * The background color that applies to visuals and other high emphasis UI.
     */
    public val primaryBackground: kotlin.String? = builder.primaryBackground
    /**
     * The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
     */
    public val primaryForeground: kotlin.String? = builder.primaryForeground
    /**
     * The background color that applies to the sheet background and sheet controls.
     */
    public val secondaryBackground: kotlin.String? = builder.secondaryBackground
    /**
     * The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
     */
    public val secondaryForeground: kotlin.String? = builder.secondaryForeground
    /**
     * The color that applies to success messages, for example the check mark for a successful download.
     */
    public val success: kotlin.String? = builder.success
    /**
     * The foreground color that applies to any text or other elements that appear over the success color.
     */
    public val successForeground: kotlin.String? = builder.successForeground
    /**
     * This color that applies to warning and informational messages.
     */
    public val warning: kotlin.String? = builder.warning
    /**
     * The foreground color that applies to any text or other elements that appear over the warning color.
     */
    public val warningForeground: kotlin.String? = builder.warningForeground

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UiColorPalette = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UiColorPalette(")
        append("accent=$accent,")
        append("accentForeground=$accentForeground,")
        append("danger=$danger,")
        append("dangerForeground=$dangerForeground,")
        append("dimension=$dimension,")
        append("dimensionForeground=$dimensionForeground,")
        append("measure=$measure,")
        append("measureForeground=$measureForeground,")
        append("primaryBackground=$primaryBackground,")
        append("primaryForeground=$primaryForeground,")
        append("secondaryBackground=$secondaryBackground,")
        append("secondaryForeground=$secondaryForeground,")
        append("success=$success,")
        append("successForeground=$successForeground,")
        append("warning=$warning,")
        append("warningForeground=$warningForeground")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accent?.hashCode() ?: 0
        result = 31 * result + (accentForeground?.hashCode() ?: 0)
        result = 31 * result + (danger?.hashCode() ?: 0)
        result = 31 * result + (dangerForeground?.hashCode() ?: 0)
        result = 31 * result + (dimension?.hashCode() ?: 0)
        result = 31 * result + (dimensionForeground?.hashCode() ?: 0)
        result = 31 * result + (measure?.hashCode() ?: 0)
        result = 31 * result + (measureForeground?.hashCode() ?: 0)
        result = 31 * result + (primaryBackground?.hashCode() ?: 0)
        result = 31 * result + (primaryForeground?.hashCode() ?: 0)
        result = 31 * result + (secondaryBackground?.hashCode() ?: 0)
        result = 31 * result + (secondaryForeground?.hashCode() ?: 0)
        result = 31 * result + (success?.hashCode() ?: 0)
        result = 31 * result + (successForeground?.hashCode() ?: 0)
        result = 31 * result + (warning?.hashCode() ?: 0)
        result = 31 * result + (warningForeground?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UiColorPalette

        if (accent != other.accent) return false
        if (accentForeground != other.accentForeground) return false
        if (danger != other.danger) return false
        if (dangerForeground != other.dangerForeground) return false
        if (dimension != other.dimension) return false
        if (dimensionForeground != other.dimensionForeground) return false
        if (measure != other.measure) return false
        if (measureForeground != other.measureForeground) return false
        if (primaryBackground != other.primaryBackground) return false
        if (primaryForeground != other.primaryForeground) return false
        if (secondaryBackground != other.secondaryBackground) return false
        if (secondaryForeground != other.secondaryForeground) return false
        if (success != other.success) return false
        if (successForeground != other.successForeground) return false
        if (warning != other.warning) return false
        if (warningForeground != other.warningForeground) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UiColorPalette = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This color is that applies to selected states and buttons.
         */
        public var accent: kotlin.String? = null
        /**
         * The foreground color that applies to any text or other elements that appear over the accent color.
         */
        public var accentForeground: kotlin.String? = null
        /**
         * The color that applies to error messages.
         */
        public var danger: kotlin.String? = null
        /**
         * The foreground color that applies to any text or other elements that appear over the error color.
         */
        public var dangerForeground: kotlin.String? = null
        /**
         * The color that applies to the names of fields that are identified as dimensions.
         */
        public var dimension: kotlin.String? = null
        /**
         * The foreground color that applies to any text or other elements that appear over the dimension color.
         */
        public var dimensionForeground: kotlin.String? = null
        /**
         * The color that applies to the names of fields that are identified as measures.
         */
        public var measure: kotlin.String? = null
        /**
         * The foreground color that applies to any text or other elements that appear over the measure color.
         */
        public var measureForeground: kotlin.String? = null
        /**
         * The background color that applies to visuals and other high emphasis UI.
         */
        public var primaryBackground: kotlin.String? = null
        /**
         * The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.
         */
        public var primaryForeground: kotlin.String? = null
        /**
         * The background color that applies to the sheet background and sheet controls.
         */
        public var secondaryBackground: kotlin.String? = null
        /**
         * The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.
         */
        public var secondaryForeground: kotlin.String? = null
        /**
         * The color that applies to success messages, for example the check mark for a successful download.
         */
        public var success: kotlin.String? = null
        /**
         * The foreground color that applies to any text or other elements that appear over the success color.
         */
        public var successForeground: kotlin.String? = null
        /**
         * This color that applies to warning and informational messages.
         */
        public var warning: kotlin.String? = null
        /**
         * The foreground color that applies to any text or other elements that appear over the warning color.
         */
        public var warningForeground: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UiColorPalette) : this() {
            this.accent = x.accent
            this.accentForeground = x.accentForeground
            this.danger = x.danger
            this.dangerForeground = x.dangerForeground
            this.dimension = x.dimension
            this.dimensionForeground = x.dimensionForeground
            this.measure = x.measure
            this.measureForeground = x.measureForeground
            this.primaryBackground = x.primaryBackground
            this.primaryForeground = x.primaryForeground
            this.secondaryBackground = x.secondaryBackground
            this.secondaryForeground = x.secondaryForeground
            this.success = x.success
            this.successForeground = x.successForeground
            this.warning = x.warning
            this.warningForeground = x.warningForeground
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UiColorPalette = UiColorPalette(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
