// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The column option of the transposed table.
 */
public class TransposedTableOption private constructor(builder: Builder) {
    /**
     * The index of a columns in a transposed table. The index range is 0-9999.
     */
    public val columnIndex: kotlin.Int? = builder.columnIndex
    /**
     * The column type of the column in a transposed table. Choose one of the following options:
     * + `ROW_HEADER_COLUMN`: Refers to the leftmost column of the row header in the transposed table.
     * + `VALUE_COLUMN`: Refers to all value columns in the transposed table.
     */
    public val columnType: aws.sdk.kotlin.services.quicksight.model.TransposedColumnType = requireNotNull(builder.columnType) { "A non-null value must be provided for columnType" }
    /**
     * The width of a column in a transposed table.
     */
    public val columnWidth: kotlin.String? = builder.columnWidth

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TransposedTableOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransposedTableOption(")
        append("columnIndex=$columnIndex,")
        append("columnType=$columnType,")
        append("columnWidth=$columnWidth")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = columnIndex ?: 0
        result = 31 * result + (columnType.hashCode())
        result = 31 * result + (columnWidth?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransposedTableOption

        if (columnIndex != other.columnIndex) return false
        if (columnType != other.columnType) return false
        if (columnWidth != other.columnWidth) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TransposedTableOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The index of a columns in a transposed table. The index range is 0-9999.
         */
        public var columnIndex: kotlin.Int? = null
        /**
         * The column type of the column in a transposed table. Choose one of the following options:
         * + `ROW_HEADER_COLUMN`: Refers to the leftmost column of the row header in the transposed table.
         * + `VALUE_COLUMN`: Refers to all value columns in the transposed table.
         */
        public var columnType: aws.sdk.kotlin.services.quicksight.model.TransposedColumnType? = null
        /**
         * The width of a column in a transposed table.
         */
        public var columnWidth: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TransposedTableOption) : this() {
            this.columnIndex = x.columnIndex
            this.columnType = x.columnType
            this.columnWidth = x.columnWidth
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TransposedTableOption = TransposedTableOption(this)

        internal fun correctErrors(): Builder {
            if (columnType == null) columnType = TransposedColumnType.SdkUnknown("no value provided")
            return this
        }
    }
}
