// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that represents a topic refresh schedule.
 */
public class TopicRefreshSchedule private constructor(builder: Builder) {
    /**
     * A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE dataset.
     */
    public val basedOnSpiceSchedule: kotlin.Boolean = builder.basedOnSpiceSchedule
    /**
     * A Boolean value that controls whether to schedule is enabled.
     */
    public val isEnabled: kotlin.Boolean = requireNotNull(builder.isEnabled) { "A non-null value must be provided for isEnabled" }
    /**
     * The time of day when the refresh should run, for example, Monday-Sunday.
     */
    public val repeatAt: kotlin.String? = builder.repeatAt
    /**
     * The starting date and time for the refresh schedule.
     */
    public val startingAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startingAt
    /**
     * The timezone that you want the refresh schedule to use.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * The type of refresh schedule. Valid values for this structure are `HOURLY`, `DAILY`, `WEEKLY`, and `MONTHLY`.
     */
    public val topicScheduleType: aws.sdk.kotlin.services.quicksight.model.TopicScheduleType? = builder.topicScheduleType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TopicRefreshSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicRefreshSchedule(")
        append("basedOnSpiceSchedule=$basedOnSpiceSchedule,")
        append("isEnabled=$isEnabled,")
        append("repeatAt=$repeatAt,")
        append("startingAt=$startingAt,")
        append("timezone=$timezone,")
        append("topicScheduleType=$topicScheduleType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = basedOnSpiceSchedule.hashCode()
        result = 31 * result + (isEnabled.hashCode())
        result = 31 * result + (repeatAt?.hashCode() ?: 0)
        result = 31 * result + (startingAt?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (topicScheduleType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicRefreshSchedule

        if (basedOnSpiceSchedule != other.basedOnSpiceSchedule) return false
        if (isEnabled != other.isEnabled) return false
        if (repeatAt != other.repeatAt) return false
        if (startingAt != other.startingAt) return false
        if (timezone != other.timezone) return false
        if (topicScheduleType != other.topicScheduleType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TopicRefreshSchedule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean value that controls whether to schedule runs at the same schedule that is specified in SPICE dataset.
         */
        public var basedOnSpiceSchedule: kotlin.Boolean = false
        /**
         * A Boolean value that controls whether to schedule is enabled.
         */
        public var isEnabled: kotlin.Boolean? = null
        /**
         * The time of day when the refresh should run, for example, Monday-Sunday.
         */
        public var repeatAt: kotlin.String? = null
        /**
         * The starting date and time for the refresh schedule.
         */
        public var startingAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timezone that you want the refresh schedule to use.
         */
        public var timezone: kotlin.String? = null
        /**
         * The type of refresh schedule. Valid values for this structure are `HOURLY`, `DAILY`, `WEEKLY`, and `MONTHLY`.
         */
        public var topicScheduleType: aws.sdk.kotlin.services.quicksight.model.TopicScheduleType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TopicRefreshSchedule) : this() {
            this.basedOnSpiceSchedule = x.basedOnSpiceSchedule
            this.isEnabled = x.isEnabled
            this.repeatAt = x.repeatAt
            this.startingAt = x.startingAt
            this.timezone = x.timezone
            this.topicScheduleType = x.topicScheduleType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TopicRefreshSchedule = TopicRefreshSchedule(this)

        internal fun correctErrors(): Builder {
            if (isEnabled == null) isEnabled = false
            return this
        }
    }
}
