// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that represents a filter used to select items for a topic.
 */
public class TopicFilter private constructor(builder: Builder) {
    /**
     * The category filter that is associated with this filter.
     */
    public val categoryFilter: aws.sdk.kotlin.services.quicksight.model.TopicCategoryFilter? = builder.categoryFilter
    /**
     * The date range filter.
     */
    public val dateRangeFilter: aws.sdk.kotlin.services.quicksight.model.TopicDateRangeFilter? = builder.dateRangeFilter
    /**
     * The class of the filter. Valid values for this structure are `ENFORCED_VALUE_FILTER`, `CONDITIONAL_VALUE_FILTER`, and `NAMED_VALUE_FILTER`.
     */
    public val filterClass: aws.sdk.kotlin.services.quicksight.model.FilterClass? = builder.filterClass
    /**
     * A description of the filter used to select items for a topic.
     */
    public val filterDescription: kotlin.String? = builder.filterDescription
    /**
     * The name of the filter.
     */
    public val filterName: kotlin.String = requireNotNull(builder.filterName) { "A non-null value must be provided for filterName" }
    /**
     * The other names or aliases for the filter.
     */
    public val filterSynonyms: List<String>? = builder.filterSynonyms
    /**
     * The type of the filter. Valid values for this structure are `CATEGORY_FILTER`, `NUMERIC_EQUALITY_FILTER`, `NUMERIC_RANGE_FILTER`, `DATE_RANGE_FILTER`, and `RELATIVE_DATE_FILTER`.
     */
    public val filterType: aws.sdk.kotlin.services.quicksight.model.NamedFilterType? = builder.filterType
    /**
     * The numeric equality filter.
     */
    public val numericEqualityFilter: aws.sdk.kotlin.services.quicksight.model.TopicNumericEqualityFilter? = builder.numericEqualityFilter
    /**
     * The numeric range filter.
     */
    public val numericRangeFilter: aws.sdk.kotlin.services.quicksight.model.TopicNumericRangeFilter? = builder.numericRangeFilter
    /**
     * The name of the field that the filter operates on.
     */
    public val operandFieldName: kotlin.String = requireNotNull(builder.operandFieldName) { "A non-null value must be provided for operandFieldName" }
    /**
     * The relative date filter.
     */
    public val relativeDateFilter: aws.sdk.kotlin.services.quicksight.model.TopicRelativeDateFilter? = builder.relativeDateFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TopicFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicFilter(")
        append("categoryFilter=$categoryFilter,")
        append("dateRangeFilter=$dateRangeFilter,")
        append("filterClass=$filterClass,")
        append("filterDescription=$filterDescription,")
        append("filterName=$filterName,")
        append("filterSynonyms=$filterSynonyms,")
        append("filterType=$filterType,")
        append("numericEqualityFilter=$numericEqualityFilter,")
        append("numericRangeFilter=$numericRangeFilter,")
        append("operandFieldName=$operandFieldName,")
        append("relativeDateFilter=$relativeDateFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categoryFilter?.hashCode() ?: 0
        result = 31 * result + (dateRangeFilter?.hashCode() ?: 0)
        result = 31 * result + (filterClass?.hashCode() ?: 0)
        result = 31 * result + (filterDescription?.hashCode() ?: 0)
        result = 31 * result + (filterName.hashCode())
        result = 31 * result + (filterSynonyms?.hashCode() ?: 0)
        result = 31 * result + (filterType?.hashCode() ?: 0)
        result = 31 * result + (numericEqualityFilter?.hashCode() ?: 0)
        result = 31 * result + (numericRangeFilter?.hashCode() ?: 0)
        result = 31 * result + (operandFieldName.hashCode())
        result = 31 * result + (relativeDateFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicFilter

        if (categoryFilter != other.categoryFilter) return false
        if (dateRangeFilter != other.dateRangeFilter) return false
        if (filterClass != other.filterClass) return false
        if (filterDescription != other.filterDescription) return false
        if (filterName != other.filterName) return false
        if (filterSynonyms != other.filterSynonyms) return false
        if (filterType != other.filterType) return false
        if (numericEqualityFilter != other.numericEqualityFilter) return false
        if (numericRangeFilter != other.numericRangeFilter) return false
        if (operandFieldName != other.operandFieldName) return false
        if (relativeDateFilter != other.relativeDateFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TopicFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The category filter that is associated with this filter.
         */
        public var categoryFilter: aws.sdk.kotlin.services.quicksight.model.TopicCategoryFilter? = null
        /**
         * The date range filter.
         */
        public var dateRangeFilter: aws.sdk.kotlin.services.quicksight.model.TopicDateRangeFilter? = null
        /**
         * The class of the filter. Valid values for this structure are `ENFORCED_VALUE_FILTER`, `CONDITIONAL_VALUE_FILTER`, and `NAMED_VALUE_FILTER`.
         */
        public var filterClass: aws.sdk.kotlin.services.quicksight.model.FilterClass? = null
        /**
         * A description of the filter used to select items for a topic.
         */
        public var filterDescription: kotlin.String? = null
        /**
         * The name of the filter.
         */
        public var filterName: kotlin.String? = null
        /**
         * The other names or aliases for the filter.
         */
        public var filterSynonyms: List<String>? = null
        /**
         * The type of the filter. Valid values for this structure are `CATEGORY_FILTER`, `NUMERIC_EQUALITY_FILTER`, `NUMERIC_RANGE_FILTER`, `DATE_RANGE_FILTER`, and `RELATIVE_DATE_FILTER`.
         */
        public var filterType: aws.sdk.kotlin.services.quicksight.model.NamedFilterType? = null
        /**
         * The numeric equality filter.
         */
        public var numericEqualityFilter: aws.sdk.kotlin.services.quicksight.model.TopicNumericEqualityFilter? = null
        /**
         * The numeric range filter.
         */
        public var numericRangeFilter: aws.sdk.kotlin.services.quicksight.model.TopicNumericRangeFilter? = null
        /**
         * The name of the field that the filter operates on.
         */
        public var operandFieldName: kotlin.String? = null
        /**
         * The relative date filter.
         */
        public var relativeDateFilter: aws.sdk.kotlin.services.quicksight.model.TopicRelativeDateFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TopicFilter) : this() {
            this.categoryFilter = x.categoryFilter
            this.dateRangeFilter = x.dateRangeFilter
            this.filterClass = x.filterClass
            this.filterDescription = x.filterDescription
            this.filterName = x.filterName
            this.filterSynonyms = x.filterSynonyms
            this.filterType = x.filterType
            this.numericEqualityFilter = x.numericEqualityFilter
            this.numericRangeFilter = x.numericRangeFilter
            this.operandFieldName = x.operandFieldName
            this.relativeDateFilter = x.relativeDateFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TopicFilter = TopicFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopicCategoryFilter] inside the given [block]
         */
        public fun categoryFilter(block: aws.sdk.kotlin.services.quicksight.model.TopicCategoryFilter.Builder.() -> kotlin.Unit) {
            this.categoryFilter = aws.sdk.kotlin.services.quicksight.model.TopicCategoryFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopicDateRangeFilter] inside the given [block]
         */
        public fun dateRangeFilter(block: aws.sdk.kotlin.services.quicksight.model.TopicDateRangeFilter.Builder.() -> kotlin.Unit) {
            this.dateRangeFilter = aws.sdk.kotlin.services.quicksight.model.TopicDateRangeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopicNumericEqualityFilter] inside the given [block]
         */
        public fun numericEqualityFilter(block: aws.sdk.kotlin.services.quicksight.model.TopicNumericEqualityFilter.Builder.() -> kotlin.Unit) {
            this.numericEqualityFilter = aws.sdk.kotlin.services.quicksight.model.TopicNumericEqualityFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopicNumericRangeFilter] inside the given [block]
         */
        public fun numericRangeFilter(block: aws.sdk.kotlin.services.quicksight.model.TopicNumericRangeFilter.Builder.() -> kotlin.Unit) {
            this.numericRangeFilter = aws.sdk.kotlin.services.quicksight.model.TopicNumericRangeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TopicRelativeDateFilter] inside the given [block]
         */
        public fun relativeDateFilter(block: aws.sdk.kotlin.services.quicksight.model.TopicRelativeDateFilter.Builder.() -> kotlin.Unit) {
            this.relativeDateFilter = aws.sdk.kotlin.services.quicksight.model.TopicRelativeDateFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterName == null) filterName = ""
            if (operandFieldName == null) operandFieldName = ""
            return this
        }
    }
}
