// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a column in a dataset.
 */
public class TopicColumn private constructor(builder: Builder) {
    /**
     * The type of aggregation that is performed on the column data when it's queried.
     */
    public val aggregation: aws.sdk.kotlin.services.quicksight.model.DefaultAggregation? = builder.aggregation
    /**
     * The list of aggregation types that are allowed for the column. Valid values for this structure are `COUNT`, `DISTINCT_COUNT`, `MIN`, `MAX`, `MEDIAN`, `SUM`, `AVERAGE`, `STDEV`, `STDEVP`, `VAR`, `VARP`, and `PERCENTILE`.
     */
    public val allowedAggregations: List<AuthorSpecifiedAggregation>? = builder.allowedAggregations
    /**
     * The other names or aliases for the column cell value.
     */
    public val cellValueSynonyms: List<CellValueSynonym>? = builder.cellValueSynonyms
    /**
     * The role of the column in the data. Valid values are `DIMENSION` and `MEASURE`.
     */
    public val columnDataRole: aws.sdk.kotlin.services.quicksight.model.ColumnDataRole? = builder.columnDataRole
    /**
     * A description of the column and its contents.
     */
    public val columnDescription: kotlin.String? = builder.columnDescription
    /**
     * A user-friendly name for the column.
     */
    public val columnFriendlyName: kotlin.String? = builder.columnFriendlyName
    /**
     * The name of the column.
     */
    public val columnName: kotlin.String = requireNotNull(builder.columnName) { "A non-null value must be provided for columnName" }
    /**
     * The other names or aliases for the column.
     */
    public val columnSynonyms: List<String>? = builder.columnSynonyms
    /**
     * The order in which data is displayed for the column when it's used in a comparative context.
     */
    public val comparativeOrder: aws.sdk.kotlin.services.quicksight.model.ComparativeOrder? = builder.comparativeOrder
    /**
     * The default formatting used for values in the column.
     */
    public val defaultFormatting: aws.sdk.kotlin.services.quicksight.model.DefaultFormatting? = builder.defaultFormatting
    /**
     * A Boolean value that indicates whether the column shows in the autocomplete functionality.
     */
    public val disableIndexing: kotlin.Boolean? = builder.disableIndexing
    /**
     * A Boolean value that indicates whether the column is included in the query results.
     */
    public val isIncludedInTopic: kotlin.Boolean = builder.isIncludedInTopic
    /**
     * A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
     */
    public val neverAggregateInFilter: kotlin.Boolean = builder.neverAggregateInFilter
    /**
     * The non additive value for the column.
     */
    public val nonAdditive: kotlin.Boolean? = builder.nonAdditive
    /**
     * The list of aggregation types that are not allowed for the column. Valid values for this structure are `COUNT`, `DISTINCT_COUNT`, `MIN`, `MAX`, `MEDIAN`, `SUM`, `AVERAGE`, `STDEV`, `STDEVP`, `VAR`, `VARP`, and `PERCENTILE`.
     */
    public val notAllowedAggregations: List<AuthorSpecifiedAggregation>? = builder.notAllowedAggregations
    /**
     * The semantic type of data contained in the column.
     */
    public val semanticType: aws.sdk.kotlin.services.quicksight.model.SemanticType? = builder.semanticType
    /**
     * The level of time precision that is used to aggregate `DateTime` values.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TopicTimeGranularity? = builder.timeGranularity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TopicColumn = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicColumn(")
        append("aggregation=$aggregation,")
        append("allowedAggregations=$allowedAggregations,")
        append("cellValueSynonyms=$cellValueSynonyms,")
        append("columnDataRole=$columnDataRole,")
        append("columnDescription=$columnDescription,")
        append("columnFriendlyName=$columnFriendlyName,")
        append("columnName=$columnName,")
        append("columnSynonyms=$columnSynonyms,")
        append("comparativeOrder=$comparativeOrder,")
        append("defaultFormatting=$defaultFormatting,")
        append("disableIndexing=$disableIndexing,")
        append("isIncludedInTopic=$isIncludedInTopic,")
        append("neverAggregateInFilter=$neverAggregateInFilter,")
        append("nonAdditive=$nonAdditive,")
        append("notAllowedAggregations=$notAllowedAggregations,")
        append("semanticType=$semanticType,")
        append("timeGranularity=$timeGranularity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregation?.hashCode() ?: 0
        result = 31 * result + (allowedAggregations?.hashCode() ?: 0)
        result = 31 * result + (cellValueSynonyms?.hashCode() ?: 0)
        result = 31 * result + (columnDataRole?.hashCode() ?: 0)
        result = 31 * result + (columnDescription?.hashCode() ?: 0)
        result = 31 * result + (columnFriendlyName?.hashCode() ?: 0)
        result = 31 * result + (columnName.hashCode())
        result = 31 * result + (columnSynonyms?.hashCode() ?: 0)
        result = 31 * result + (comparativeOrder?.hashCode() ?: 0)
        result = 31 * result + (defaultFormatting?.hashCode() ?: 0)
        result = 31 * result + (disableIndexing?.hashCode() ?: 0)
        result = 31 * result + (isIncludedInTopic.hashCode())
        result = 31 * result + (neverAggregateInFilter.hashCode())
        result = 31 * result + (nonAdditive?.hashCode() ?: 0)
        result = 31 * result + (notAllowedAggregations?.hashCode() ?: 0)
        result = 31 * result + (semanticType?.hashCode() ?: 0)
        result = 31 * result + (timeGranularity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicColumn

        if (aggregation != other.aggregation) return false
        if (allowedAggregations != other.allowedAggregations) return false
        if (cellValueSynonyms != other.cellValueSynonyms) return false
        if (columnDataRole != other.columnDataRole) return false
        if (columnDescription != other.columnDescription) return false
        if (columnFriendlyName != other.columnFriendlyName) return false
        if (columnName != other.columnName) return false
        if (columnSynonyms != other.columnSynonyms) return false
        if (comparativeOrder != other.comparativeOrder) return false
        if (defaultFormatting != other.defaultFormatting) return false
        if (disableIndexing != other.disableIndexing) return false
        if (isIncludedInTopic != other.isIncludedInTopic) return false
        if (neverAggregateInFilter != other.neverAggregateInFilter) return false
        if (nonAdditive != other.nonAdditive) return false
        if (notAllowedAggregations != other.notAllowedAggregations) return false
        if (semanticType != other.semanticType) return false
        if (timeGranularity != other.timeGranularity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TopicColumn = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of aggregation that is performed on the column data when it's queried.
         */
        public var aggregation: aws.sdk.kotlin.services.quicksight.model.DefaultAggregation? = null
        /**
         * The list of aggregation types that are allowed for the column. Valid values for this structure are `COUNT`, `DISTINCT_COUNT`, `MIN`, `MAX`, `MEDIAN`, `SUM`, `AVERAGE`, `STDEV`, `STDEVP`, `VAR`, `VARP`, and `PERCENTILE`.
         */
        public var allowedAggregations: List<AuthorSpecifiedAggregation>? = null
        /**
         * The other names or aliases for the column cell value.
         */
        public var cellValueSynonyms: List<CellValueSynonym>? = null
        /**
         * The role of the column in the data. Valid values are `DIMENSION` and `MEASURE`.
         */
        public var columnDataRole: aws.sdk.kotlin.services.quicksight.model.ColumnDataRole? = null
        /**
         * A description of the column and its contents.
         */
        public var columnDescription: kotlin.String? = null
        /**
         * A user-friendly name for the column.
         */
        public var columnFriendlyName: kotlin.String? = null
        /**
         * The name of the column.
         */
        public var columnName: kotlin.String? = null
        /**
         * The other names or aliases for the column.
         */
        public var columnSynonyms: List<String>? = null
        /**
         * The order in which data is displayed for the column when it's used in a comparative context.
         */
        public var comparativeOrder: aws.sdk.kotlin.services.quicksight.model.ComparativeOrder? = null
        /**
         * The default formatting used for values in the column.
         */
        public var defaultFormatting: aws.sdk.kotlin.services.quicksight.model.DefaultFormatting? = null
        /**
         * A Boolean value that indicates whether the column shows in the autocomplete functionality.
         */
        public var disableIndexing: kotlin.Boolean? = null
        /**
         * A Boolean value that indicates whether the column is included in the query results.
         */
        public var isIncludedInTopic: kotlin.Boolean = false
        /**
         * A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
         */
        public var neverAggregateInFilter: kotlin.Boolean = false
        /**
         * The non additive value for the column.
         */
        public var nonAdditive: kotlin.Boolean? = null
        /**
         * The list of aggregation types that are not allowed for the column. Valid values for this structure are `COUNT`, `DISTINCT_COUNT`, `MIN`, `MAX`, `MEDIAN`, `SUM`, `AVERAGE`, `STDEV`, `STDEVP`, `VAR`, `VARP`, and `PERCENTILE`.
         */
        public var notAllowedAggregations: List<AuthorSpecifiedAggregation>? = null
        /**
         * The semantic type of data contained in the column.
         */
        public var semanticType: aws.sdk.kotlin.services.quicksight.model.SemanticType? = null
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TopicTimeGranularity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TopicColumn) : this() {
            this.aggregation = x.aggregation
            this.allowedAggregations = x.allowedAggregations
            this.cellValueSynonyms = x.cellValueSynonyms
            this.columnDataRole = x.columnDataRole
            this.columnDescription = x.columnDescription
            this.columnFriendlyName = x.columnFriendlyName
            this.columnName = x.columnName
            this.columnSynonyms = x.columnSynonyms
            this.comparativeOrder = x.comparativeOrder
            this.defaultFormatting = x.defaultFormatting
            this.disableIndexing = x.disableIndexing
            this.isIncludedInTopic = x.isIncludedInTopic
            this.neverAggregateInFilter = x.neverAggregateInFilter
            this.nonAdditive = x.nonAdditive
            this.notAllowedAggregations = x.notAllowedAggregations
            this.semanticType = x.semanticType
            this.timeGranularity = x.timeGranularity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TopicColumn = TopicColumn(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ComparativeOrder] inside the given [block]
         */
        public fun comparativeOrder(block: aws.sdk.kotlin.services.quicksight.model.ComparativeOrder.Builder.() -> kotlin.Unit) {
            this.comparativeOrder = aws.sdk.kotlin.services.quicksight.model.ComparativeOrder.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFormatting] inside the given [block]
         */
        public fun defaultFormatting(block: aws.sdk.kotlin.services.quicksight.model.DefaultFormatting.Builder.() -> kotlin.Unit) {
            this.defaultFormatting = aws.sdk.kotlin.services.quicksight.model.DefaultFormatting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SemanticType] inside the given [block]
         */
        public fun semanticType(block: aws.sdk.kotlin.services.quicksight.model.SemanticType.Builder.() -> kotlin.Unit) {
            this.semanticType = aws.sdk.kotlin.services.quicksight.model.SemanticType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (columnName == null) columnName = ""
            return this
        }
    }
}
