// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `TopBottomFilter` filters values that are at the top or the bottom.
 */
public class TopBottomFilter private constructor(builder: Builder) {
    /**
     * The aggregation and sort configuration of the top bottom filter.
     */
    public val aggregationSortConfigurations: List<AggregationSortConfiguration> = requireNotNull(builder.aggregationSortConfigurations) { "A non-null value must be provided for aggregationSortConfigurations" }
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * The number of items to include in the top bottom filter results.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The parameter whose value should be used for the filter value.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * The level of time precision that is used to aggregate `DateTime` values.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = builder.timeGranularity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TopBottomFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopBottomFilter(")
        append("aggregationSortConfigurations=$aggregationSortConfigurations,")
        append("column=$column,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("filterId=$filterId,")
        append("limit=$limit,")
        append("parameterName=$parameterName,")
        append("timeGranularity=$timeGranularity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationSortConfigurations.hashCode()
        result = 31 * result + (column?.hashCode() ?: 0)
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (timeGranularity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopBottomFilter

        if (aggregationSortConfigurations != other.aggregationSortConfigurations) return false
        if (column != other.column) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (filterId != other.filterId) return false
        if (limit != other.limit) return false
        if (parameterName != other.parameterName) return false
        if (timeGranularity != other.timeGranularity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TopBottomFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The aggregation and sort configuration of the top bottom filter.
         */
        public var aggregationSortConfigurations: List<AggregationSortConfiguration>? = null
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * The number of items to include in the top bottom filter results.
         */
        public var limit: kotlin.Int? = null
        /**
         * The parameter whose value should be used for the filter value.
         */
        public var parameterName: kotlin.String? = null
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TopBottomFilter) : this() {
            this.aggregationSortConfigurations = x.aggregationSortConfigurations
            this.column = x.column
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.filterId = x.filterId
            this.limit = x.limit
            this.parameterName = x.parameterName
            this.timeGranularity = x.timeGranularity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TopBottomFilter = TopBottomFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (aggregationSortConfigurations == null) aggregationSortConfigurations = emptyList()
            if (filterId == null) filterId = ""
            return this
        }
    }
}
