// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A `TimeRangeFilter` filters values that are between two specified values.
 */
public class TimeRangeFilter private constructor(builder: Builder) {
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * The exclude period of the time range filter.
     */
    public val excludePeriodConfiguration: aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration? = builder.excludePeriodConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * Determines whether the maximum value in the filter value range should be included in the filtered results.
     */
    public val includeMaximum: kotlin.Boolean? = builder.includeMaximum
    /**
     * Determines whether the minimum value in the filter value range should be included in the filtered results.
     */
    public val includeMinimum: kotlin.Boolean? = builder.includeMinimum
    /**
     * This option determines how null values should be treated when filtering data.
     * + `ALL_VALUES`: Include null values in filtered results.
     * + `NULLS_ONLY`: Only include null values in filtered results.
     * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
     */
    public val nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption = requireNotNull(builder.nullOption) { "A non-null value must be provided for nullOption" }
    /**
     * The maximum value for the filter value range.
     */
    public val rangeMaximumValue: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue? = builder.rangeMaximumValue
    /**
     * The minimum value for the filter value range.
     */
    public val rangeMinimumValue: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue? = builder.rangeMinimumValue
    /**
     * The level of time precision that is used to aggregate `DateTime` values.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = builder.timeGranularity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeRangeFilter(")
        append("column=$column,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("excludePeriodConfiguration=$excludePeriodConfiguration,")
        append("filterId=$filterId,")
        append("includeMaximum=$includeMaximum,")
        append("includeMinimum=$includeMinimum,")
        append("nullOption=$nullOption,")
        append("rangeMaximumValue=$rangeMaximumValue,")
        append("rangeMinimumValue=$rangeMinimumValue,")
        append("timeGranularity=$timeGranularity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = column?.hashCode() ?: 0
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (excludePeriodConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (includeMaximum?.hashCode() ?: 0)
        result = 31 * result + (includeMinimum?.hashCode() ?: 0)
        result = 31 * result + (nullOption.hashCode())
        result = 31 * result + (rangeMaximumValue?.hashCode() ?: 0)
        result = 31 * result + (rangeMinimumValue?.hashCode() ?: 0)
        result = 31 * result + (timeGranularity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeRangeFilter

        if (column != other.column) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (excludePeriodConfiguration != other.excludePeriodConfiguration) return false
        if (filterId != other.filterId) return false
        if (includeMaximum != other.includeMaximum) return false
        if (includeMinimum != other.includeMinimum) return false
        if (nullOption != other.nullOption) return false
        if (rangeMaximumValue != other.rangeMaximumValue) return false
        if (rangeMinimumValue != other.rangeMinimumValue) return false
        if (timeGranularity != other.timeGranularity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * The exclude period of the time range filter.
         */
        public var excludePeriodConfiguration: aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * Determines whether the maximum value in the filter value range should be included in the filtered results.
         */
        public var includeMaximum: kotlin.Boolean? = null
        /**
         * Determines whether the minimum value in the filter value range should be included in the filtered results.
         */
        public var includeMinimum: kotlin.Boolean? = null
        /**
         * This option determines how null values should be treated when filtering data.
         * + `ALL_VALUES`: Include null values in filtered results.
         * + `NULLS_ONLY`: Only include null values in filtered results.
         * + `NON_NULLS_ONLY`: Exclude null values from filtered results.
         */
        public var nullOption: aws.sdk.kotlin.services.quicksight.model.FilterNullOption? = null
        /**
         * The maximum value for the filter value range.
         */
        public var rangeMaximumValue: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue? = null
        /**
         * The minimum value for the filter value range.
         */
        public var rangeMinimumValue: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue? = null
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter) : this() {
            this.column = x.column
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.excludePeriodConfiguration = x.excludePeriodConfiguration
            this.filterId = x.filterId
            this.includeMaximum = x.includeMaximum
            this.includeMinimum = x.includeMinimum
            this.nullOption = x.nullOption
            this.rangeMaximumValue = x.rangeMaximumValue
            this.rangeMinimumValue = x.rangeMinimumValue
            this.timeGranularity = x.timeGranularity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TimeRangeFilter = TimeRangeFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration] inside the given [block]
         */
        public fun excludePeriodConfiguration(block: aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration.Builder.() -> kotlin.Unit) {
            this.excludePeriodConfiguration = aws.sdk.kotlin.services.quicksight.model.ExcludePeriodConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue] inside the given [block]
         */
        public fun rangeMaximumValue(block: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue.Builder.() -> kotlin.Unit) {
            this.rangeMaximumValue = aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue] inside the given [block]
         */
        public fun rangeMinimumValue(block: aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue.Builder.() -> kotlin.Unit) {
            this.rangeMinimumValue = aws.sdk.kotlin.services.quicksight.model.TimeRangeFilterValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            if (nullOption == null) nullOption = FilterNullOption.SdkUnknown("no value provided")
            return this
        }
    }
}
