// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The time range drill down filter.
 */
public class TimeRangeDrillDownFilter private constructor(builder: Builder) {
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The maximum value for the filter value range.
     */
    public val rangeMaximum: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.rangeMaximum) { "A non-null value must be provided for rangeMaximum" }
    /**
     * The minimum value for the filter value range.
     */
    public val rangeMinimum: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.rangeMinimum) { "A non-null value must be provided for rangeMinimum" }
    /**
     * The level of time precision that is used to aggregate `DateTime` values.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity = requireNotNull(builder.timeGranularity) { "A non-null value must be provided for timeGranularity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TimeRangeDrillDownFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeRangeDrillDownFilter(")
        append("column=$column,")
        append("rangeMaximum=$rangeMaximum,")
        append("rangeMinimum=$rangeMinimum,")
        append("timeGranularity=$timeGranularity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = column?.hashCode() ?: 0
        result = 31 * result + (rangeMaximum.hashCode())
        result = 31 * result + (rangeMinimum.hashCode())
        result = 31 * result + (timeGranularity.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeRangeDrillDownFilter

        if (column != other.column) return false
        if (rangeMaximum != other.rangeMaximum) return false
        if (rangeMinimum != other.rangeMinimum) return false
        if (timeGranularity != other.timeGranularity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TimeRangeDrillDownFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The maximum value for the filter value range.
         */
        public var rangeMaximum: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The minimum value for the filter value range.
         */
        public var rangeMinimum: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TimeRangeDrillDownFilter) : this() {
            this.column = x.column
            this.rangeMaximum = x.rangeMaximum
            this.rangeMinimum = x.rangeMinimum
            this.timeGranularity = x.timeGranularity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TimeRangeDrillDownFilter = TimeRangeDrillDownFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (rangeMaximum == null) rangeMaximum = Instant.fromEpochSeconds(0)
            if (rangeMinimum == null) rangeMinimum = Instant.fromEpochSeconds(0)
            if (timeGranularity == null) timeGranularity = TimeGranularity.SdkUnknown("no value provided")
            return this
        }
    }
}
