// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A `TimeEqualityFilter` filters values that are equal to a given value.
 */
public class TimeEqualityFilter private constructor(builder: Builder) {
    /**
     * The column that the filter is applied to.
     */
    public val column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = builder.column
    /**
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
     */
    public val defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = builder.defaultFilterControlConfiguration
    /**
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public val filterId: kotlin.String = requireNotNull(builder.filterId) { "A non-null value must be provided for filterId" }
    /**
     * The parameter whose value should be used for the filter value.
     *
     * This field is mutually exclusive to `Value` and `RollingDate`.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * The rolling date input for the `TimeEquality` filter.
     *
     * This field is mutually exclusive to `Value` and `ParameterName`.
     */
    public val rollingDate: aws.sdk.kotlin.services.quicksight.model.RollingDateConfiguration? = builder.rollingDate
    /**
     * The level of time precision that is used to aggregate `DateTime` values.
     */
    public val timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = builder.timeGranularity
    /**
     * The value of a `TimeEquality` filter.
     *
     * This field is mutually exclusive to `RollingDate` and `ParameterName`.
     */
    public val value: aws.smithy.kotlin.runtime.time.Instant? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeEqualityFilter(")
        append("column=$column,")
        append("defaultFilterControlConfiguration=$defaultFilterControlConfiguration,")
        append("filterId=$filterId,")
        append("parameterName=$parameterName,")
        append("rollingDate=$rollingDate,")
        append("timeGranularity=$timeGranularity,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = column?.hashCode() ?: 0
        result = 31 * result + (defaultFilterControlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filterId.hashCode())
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (rollingDate?.hashCode() ?: 0)
        result = 31 * result + (timeGranularity?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeEqualityFilter

        if (column != other.column) return false
        if (defaultFilterControlConfiguration != other.defaultFilterControlConfiguration) return false
        if (filterId != other.filterId) return false
        if (parameterName != other.parameterName) return false
        if (rollingDate != other.rollingDate) return false
        if (timeGranularity != other.timeGranularity) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The column that the filter is applied to.
         */
        public var column: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier? = null
        /**
         * The default configurations for the associated controls. This applies only for filters that are scoped to multiple sheets.
         */
        public var defaultFilterControlConfiguration: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration? = null
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         */
        public var filterId: kotlin.String? = null
        /**
         * The parameter whose value should be used for the filter value.
         *
         * This field is mutually exclusive to `Value` and `RollingDate`.
         */
        public var parameterName: kotlin.String? = null
        /**
         * The rolling date input for the `TimeEquality` filter.
         *
         * This field is mutually exclusive to `Value` and `ParameterName`.
         */
        public var rollingDate: aws.sdk.kotlin.services.quicksight.model.RollingDateConfiguration? = null
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         */
        public var timeGranularity: aws.sdk.kotlin.services.quicksight.model.TimeGranularity? = null
        /**
         * The value of a `TimeEquality` filter.
         *
         * This field is mutually exclusive to `RollingDate` and `ParameterName`.
         */
        public var value: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter) : this() {
            this.column = x.column
            this.defaultFilterControlConfiguration = x.defaultFilterControlConfiguration
            this.filterId = x.filterId
            this.parameterName = x.parameterName
            this.rollingDate = x.rollingDate
            this.timeGranularity = x.timeGranularity
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TimeEqualityFilter = TimeEqualityFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier] inside the given [block]
         */
        public fun column(block: aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.Builder.() -> kotlin.Unit) {
            this.column = aws.sdk.kotlin.services.quicksight.model.ColumnIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration] inside the given [block]
         */
        public fun defaultFilterControlConfiguration(block: aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.Builder.() -> kotlin.Unit) {
            this.defaultFilterControlConfiguration = aws.sdk.kotlin.services.quicksight.model.DefaultFilterControlConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RollingDateConfiguration] inside the given [block]
         */
        public fun rollingDate(block: aws.sdk.kotlin.services.quicksight.model.RollingDateConfiguration.Builder.() -> kotlin.Unit) {
            this.rollingDate = aws.sdk.kotlin.services.quicksight.model.RollingDateConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (filterId == null) filterId = ""
            return this
        }
    }
}
