// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A version of a theme.
 */
public class ThemeVersion private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.
     */
    public val baseThemeId: kotlin.String? = builder.baseThemeId
    /**
     * The theme configuration, which contains all the theme display properties.
     */
    public val configuration: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration? = builder.configuration
    /**
     * The date and time that this theme version was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the theme.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Errors associated with the theme.
     */
    public val errors: List<ThemeError>? = builder.errors
    /**
     * The status of the theme version.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = builder.status
    /**
     * The version number of the theme.
     */
    public val versionNumber: kotlin.Long? = builder.versionNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ThemeVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThemeVersion(")
        append("arn=$arn,")
        append("baseThemeId=$baseThemeId,")
        append("configuration=$configuration,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("errors=$errors,")
        append("status=$status,")
        append("versionNumber=$versionNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (baseThemeId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (versionNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThemeVersion

        if (arn != other.arn) return false
        if (baseThemeId != other.baseThemeId) return false
        if (configuration != other.configuration) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (errors != other.errors) return false
        if (status != other.status) return false
        if (versionNumber != other.versionNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ThemeVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.
         */
        public var baseThemeId: kotlin.String? = null
        /**
         * The theme configuration, which contains all the theme display properties.
         */
        public var configuration: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration? = null
        /**
         * The date and time that this theme version was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the theme.
         */
        public var description: kotlin.String? = null
        /**
         * Errors associated with the theme.
         */
        public var errors: List<ThemeError>? = null
        /**
         * The status of the theme version.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = null
        /**
         * The version number of the theme.
         */
        public var versionNumber: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ThemeVersion) : this() {
            this.arn = x.arn
            this.baseThemeId = x.baseThemeId
            this.configuration = x.configuration
            this.createdTime = x.createdTime
            this.description = x.description
            this.errors = x.errors
            this.status = x.status
            this.versionNumber = x.versionNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ThemeVersion = ThemeVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
