// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The detailed definition of a template.
 */
public class TemplateVersionDefinition private constructor(builder: Builder) {
    /**
     * The configuration for default analysis settings.
     */
    public val analysisDefaults: aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults? = builder.analysisDefaults
    /**
     * An array of calculated field definitions for the template.
     */
    public val calculatedFields: List<CalculatedField>? = builder.calculatedFields
    /**
     * An array of template-level column configurations. Column configurations are used to set default formatting for a column that's used throughout a template.
     */
    public val columnConfigurations: List<ColumnConfiguration>? = builder.columnConfigurations
    /**
     * An array of dataset configurations. These configurations define the required columns for each dataset used within a template.
     */
    public val dataSetConfigurations: List<DataSetConfiguration> = requireNotNull(builder.dataSetConfigurations) { "A non-null value must be provided for dataSetConfigurations" }
    /**
     * Filter definitions for a template.
     *
     * For more information, see [Filtering Data](https://docs.aws.amazon.com/quicksight/latest/user/filtering-visual-data.html) in the *Amazon QuickSight User Guide*.
     */
    public val filterGroups: List<FilterGroup>? = builder.filterGroups
    /**
     * An array of option definitions for a template.
     */
    public val options: aws.sdk.kotlin.services.quicksight.model.AssetOptions? = builder.options
    /**
     * An array of parameter declarations for a template.
     *
     * *Parameters* are named variables that can transfer a value for use by an action or an object.
     *
     * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide*.
     */
    public val parameterDeclarations: List<ParameterDeclaration>? = builder.parameterDeclarations
    /**
     * A structure that describes the query execution options.
     */
    public val queryExecutionOptions: aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions? = builder.queryExecutionOptions
    /**
     * An array of sheet definitions for a template.
     */
    public val sheets: List<SheetDefinition>? = builder.sheets
    /**
     * The static files for the definition.
     */
    public val staticFiles: List<StaticFile>? = builder.staticFiles

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TemplateVersionDefinition(")
        append("analysisDefaults=$analysisDefaults,")
        append("calculatedFields=$calculatedFields,")
        append("columnConfigurations=$columnConfigurations,")
        append("dataSetConfigurations=$dataSetConfigurations,")
        append("filterGroups=$filterGroups,")
        append("options=$options,")
        append("parameterDeclarations=$parameterDeclarations,")
        append("queryExecutionOptions=$queryExecutionOptions,")
        append("sheets=$sheets,")
        append("staticFiles=$staticFiles")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisDefaults?.hashCode() ?: 0
        result = 31 * result + (calculatedFields?.hashCode() ?: 0)
        result = 31 * result + (columnConfigurations?.hashCode() ?: 0)
        result = 31 * result + (dataSetConfigurations.hashCode())
        result = 31 * result + (filterGroups?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (parameterDeclarations?.hashCode() ?: 0)
        result = 31 * result + (queryExecutionOptions?.hashCode() ?: 0)
        result = 31 * result + (sheets?.hashCode() ?: 0)
        result = 31 * result + (staticFiles?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TemplateVersionDefinition

        if (analysisDefaults != other.analysisDefaults) return false
        if (calculatedFields != other.calculatedFields) return false
        if (columnConfigurations != other.columnConfigurations) return false
        if (dataSetConfigurations != other.dataSetConfigurations) return false
        if (filterGroups != other.filterGroups) return false
        if (options != other.options) return false
        if (parameterDeclarations != other.parameterDeclarations) return false
        if (queryExecutionOptions != other.queryExecutionOptions) return false
        if (sheets != other.sheets) return false
        if (staticFiles != other.staticFiles) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for default analysis settings.
         */
        public var analysisDefaults: aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults? = null
        /**
         * An array of calculated field definitions for the template.
         */
        public var calculatedFields: List<CalculatedField>? = null
        /**
         * An array of template-level column configurations. Column configurations are used to set default formatting for a column that's used throughout a template.
         */
        public var columnConfigurations: List<ColumnConfiguration>? = null
        /**
         * An array of dataset configurations. These configurations define the required columns for each dataset used within a template.
         */
        public var dataSetConfigurations: List<DataSetConfiguration>? = null
        /**
         * Filter definitions for a template.
         *
         * For more information, see [Filtering Data](https://docs.aws.amazon.com/quicksight/latest/user/filtering-visual-data.html) in the *Amazon QuickSight User Guide*.
         */
        public var filterGroups: List<FilterGroup>? = null
        /**
         * An array of option definitions for a template.
         */
        public var options: aws.sdk.kotlin.services.quicksight.model.AssetOptions? = null
        /**
         * An array of parameter declarations for a template.
         *
         * *Parameters* are named variables that can transfer a value for use by an action or an object.
         *
         * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide*.
         */
        public var parameterDeclarations: List<ParameterDeclaration>? = null
        /**
         * A structure that describes the query execution options.
         */
        public var queryExecutionOptions: aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions? = null
        /**
         * An array of sheet definitions for a template.
         */
        public var sheets: List<SheetDefinition>? = null
        /**
         * The static files for the definition.
         */
        public var staticFiles: List<StaticFile>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition) : this() {
            this.analysisDefaults = x.analysisDefaults
            this.calculatedFields = x.calculatedFields
            this.columnConfigurations = x.columnConfigurations
            this.dataSetConfigurations = x.dataSetConfigurations
            this.filterGroups = x.filterGroups
            this.options = x.options
            this.parameterDeclarations = x.parameterDeclarations
            this.queryExecutionOptions = x.queryExecutionOptions
            this.sheets = x.sheets
            this.staticFiles = x.staticFiles
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.TemplateVersionDefinition = TemplateVersionDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults] inside the given [block]
         */
        public fun analysisDefaults(block: aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults.Builder.() -> kotlin.Unit) {
            this.analysisDefaults = aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AssetOptions] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.quicksight.model.AssetOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.quicksight.model.AssetOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions] inside the given [block]
         */
        public fun queryExecutionOptions(block: aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions.Builder.() -> kotlin.Unit) {
            this.queryExecutionOptions = aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataSetConfigurations == null) dataSetConfigurations = emptyList()
            return this
        }
    }
}
