// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A parameter declaration for the `String` data type.
 */
public class StringParameterDeclaration private constructor(builder: Builder) {
    /**
     * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.
     */
    public val defaultValues: aws.sdk.kotlin.services.quicksight.model.StringDefaultValues? = builder.defaultValues
    /**
     * A list of dataset parameters that are mapped to an analysis parameter.
     */
    public val mappedDataSetParameters: List<MappedDataSetParameter>? = builder.mappedDataSetParameters
    /**
     * The name of the parameter that is being declared.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The value type determines whether the parameter is a single-value or multi-value parameter.
     */
    public val parameterValueType: aws.sdk.kotlin.services.quicksight.model.ParameterValueType = requireNotNull(builder.parameterValueType) { "A non-null value must be provided for parameterValueType" }
    /**
     * The configuration that defines the default value of a `String` parameter when a value has not been set.
     */
    public val valueWhenUnset: aws.sdk.kotlin.services.quicksight.model.StringValueWhenUnsetConfiguration? = builder.valueWhenUnset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.StringParameterDeclaration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StringParameterDeclaration(")
        append("defaultValues=$defaultValues,")
        append("mappedDataSetParameters=$mappedDataSetParameters,")
        append("name=$name,")
        append("parameterValueType=$parameterValueType,")
        append("valueWhenUnset=$valueWhenUnset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultValues?.hashCode() ?: 0
        result = 31 * result + (mappedDataSetParameters?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (parameterValueType.hashCode())
        result = 31 * result + (valueWhenUnset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StringParameterDeclaration

        if (defaultValues != other.defaultValues) return false
        if (mappedDataSetParameters != other.mappedDataSetParameters) return false
        if (name != other.name) return false
        if (parameterValueType != other.parameterValueType) return false
        if (valueWhenUnset != other.valueWhenUnset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.StringParameterDeclaration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value can be provided.
         */
        public var defaultValues: aws.sdk.kotlin.services.quicksight.model.StringDefaultValues? = null
        /**
         * A list of dataset parameters that are mapped to an analysis parameter.
         */
        public var mappedDataSetParameters: List<MappedDataSetParameter>? = null
        /**
         * The name of the parameter that is being declared.
         */
        public var name: kotlin.String? = null
        /**
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         */
        public var parameterValueType: aws.sdk.kotlin.services.quicksight.model.ParameterValueType? = null
        /**
         * The configuration that defines the default value of a `String` parameter when a value has not been set.
         */
        public var valueWhenUnset: aws.sdk.kotlin.services.quicksight.model.StringValueWhenUnsetConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.StringParameterDeclaration) : this() {
            this.defaultValues = x.defaultValues
            this.mappedDataSetParameters = x.mappedDataSetParameters
            this.name = x.name
            this.parameterValueType = x.parameterValueType
            this.valueWhenUnset = x.valueWhenUnset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.StringParameterDeclaration = StringParameterDeclaration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.StringDefaultValues] inside the given [block]
         */
        public fun defaultValues(block: aws.sdk.kotlin.services.quicksight.model.StringDefaultValues.Builder.() -> kotlin.Unit) {
            this.defaultValues = aws.sdk.kotlin.services.quicksight.model.StringDefaultValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.StringValueWhenUnsetConfiguration] inside the given [block]
         */
        public fun valueWhenUnset(block: aws.sdk.kotlin.services.quicksight.model.StringValueWhenUnsetConfiguration.Builder.() -> kotlin.Unit) {
            this.valueWhenUnset = aws.sdk.kotlin.services.quicksight.model.StringValueWhenUnsetConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (parameterValueType == null) parameterValueType = ParameterValueType.SdkUnknown("no value provided")
            return this
        }
    }
}
