// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure that contains the Amazon S3 location to download the static file from.
 */
public class StaticFileS3SourceOptions private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The identifier of the static file in the Amazon S3 bucket.
     */
    public val objectKey: kotlin.String = requireNotNull(builder.objectKey) { "A non-null value must be provided for objectKey" }
    /**
     * The Region of the Amazon S3 account that contains the bucket.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.StaticFileS3SourceOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StaticFileS3SourceOptions(")
        append("bucketName=$bucketName,")
        append("objectKey=$objectKey,")
        append("region=$region")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (objectKey.hashCode())
        result = 31 * result + (region.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StaticFileS3SourceOptions

        if (bucketName != other.bucketName) return false
        if (objectKey != other.objectKey) return false
        if (region != other.region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.StaticFileS3SourceOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Amazon S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The identifier of the static file in the Amazon S3 bucket.
         */
        public var objectKey: kotlin.String? = null
        /**
         * The Region of the Amazon S3 account that contains the bucket.
         */
        public var region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.StaticFileS3SourceOptions) : this() {
            this.bucketName = x.bucketName
            this.objectKey = x.objectKey
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.StaticFileS3SourceOptions = StaticFileS3SourceOptions(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (objectKey == null) objectKey = ""
            if (region == null) region = ""
            return this
        }
    }
}
