// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartDashboardSnapshotJobRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The ID of the dashboard that you want to start a snapshot job for.
     */
    public val dashboardId: kotlin.String? = builder.dashboardId
    /**
     * A structure that describes the configuration of the dashboard snapshot.
     */
    public val snapshotConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration? = builder.snapshotConfiguration
    /**
     * An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running. This ID can be used to poll the status of a job with a `DescribeDashboardSnapshotJob` while the job runs. You can reuse this ID for another job 24 hours after the current job is completed.
     */
    public val snapshotJobId: kotlin.String? = builder.snapshotJobId
    /**
     * A structure that contains information about the anonymous users that the generated snapshot is for. This API will not return information about registered Amazon QuickSight.
     */
    public val userConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfiguration? = builder.userConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDashboardSnapshotJobRequest(")
        append("awsAccountId=$awsAccountId,")
        append("dashboardId=$dashboardId,")
        append("snapshotConfiguration=$snapshotConfiguration,")
        append("snapshotJobId=$snapshotJobId,")
        append("userConfiguration=$userConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (dashboardId?.hashCode() ?: 0)
        result = 31 * result + (snapshotConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotJobId?.hashCode() ?: 0)
        result = 31 * result + (userConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDashboardSnapshotJobRequest

        if (awsAccountId != other.awsAccountId) return false
        if (dashboardId != other.dashboardId) return false
        if (snapshotConfiguration != other.snapshotConfiguration) return false
        if (snapshotJobId != other.snapshotJobId) return false
        if (userConfiguration != other.userConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The ID of the dashboard that you want to start a snapshot job for.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * A structure that describes the configuration of the dashboard snapshot.
         */
        public var snapshotConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration? = null
        /**
         * An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running. This ID can be used to poll the status of a job with a `DescribeDashboardSnapshotJob` while the job runs. You can reuse this ID for another job 24 hours after the current job is completed.
         */
        public var snapshotJobId: kotlin.String? = null
        /**
         * A structure that contains information about the anonymous users that the generated snapshot is for. This API will not return information about registered Amazon QuickSight.
         */
        public var userConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.dashboardId = x.dashboardId
            this.snapshotConfiguration = x.snapshotConfiguration
            this.snapshotJobId = x.snapshotJobId
            this.userConfiguration = x.userConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobRequest = StartDashboardSnapshotJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration] inside the given [block]
         */
        public fun snapshotConfiguration(block: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration.Builder.() -> kotlin.Unit) {
            this.snapshotConfiguration = aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfiguration] inside the given [block]
         */
        public fun userConfiguration(block: aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfiguration.Builder.() -> kotlin.Unit) {
            this.userConfiguration = aws.sdk.kotlin.services.quicksight.model.SnapshotUserConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
