// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters that are required to connect to a Starburst data source.
 */
public class StarburstParameters private constructor(builder: Builder) {
    /**
     * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth authentication types.
     */
    public val authenticationType: aws.sdk.kotlin.services.quicksight.model.AuthenticationType? = builder.authenticationType
    /**
     * The catalog name for the Starburst data source.
     */
    public val catalog: kotlin.String = requireNotNull(builder.catalog) { "A non-null value must be provided for catalog" }
    /**
     * The database access control role.
     */
    public val databaseAccessControlRole: kotlin.String? = builder.databaseAccessControlRole
    /**
     * The host name of the Starburst data source.
     */
    public val host: kotlin.String = requireNotNull(builder.host) { "A non-null value must be provided for host" }
    /**
     * An object that contains information needed to create a data source connection between an Amazon QuickSight account and Starburst.
     */
    public val oAuthParameters: aws.sdk.kotlin.services.quicksight.model.OAuthParameters? = builder.oAuthParameters
    /**
     * The port for the Starburst data source.
     */
    public val port: kotlin.Int = requireNotNull(builder.port) { "A non-null value must be provided for port" }
    /**
     * The product type for the Starburst data source.
     */
    public val productType: aws.sdk.kotlin.services.quicksight.model.StarburstProductType? = builder.productType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.StarburstParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StarburstParameters(")
        append("authenticationType=$authenticationType,")
        append("catalog=$catalog,")
        append("databaseAccessControlRole=$databaseAccessControlRole,")
        append("host=$host,")
        append("oAuthParameters=$oAuthParameters,")
        append("port=$port,")
        append("productType=$productType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (catalog.hashCode())
        result = 31 * result + (databaseAccessControlRole?.hashCode() ?: 0)
        result = 31 * result + (host.hashCode())
        result = 31 * result + (oAuthParameters?.hashCode() ?: 0)
        result = 31 * result + (port)
        result = 31 * result + (productType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StarburstParameters

        if (authenticationType != other.authenticationType) return false
        if (catalog != other.catalog) return false
        if (databaseAccessControlRole != other.databaseAccessControlRole) return false
        if (host != other.host) return false
        if (oAuthParameters != other.oAuthParameters) return false
        if (port != other.port) return false
        if (productType != other.productType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.StarburstParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth authentication types.
         */
        public var authenticationType: aws.sdk.kotlin.services.quicksight.model.AuthenticationType? = null
        /**
         * The catalog name for the Starburst data source.
         */
        public var catalog: kotlin.String? = null
        /**
         * The database access control role.
         */
        public var databaseAccessControlRole: kotlin.String? = null
        /**
         * The host name of the Starburst data source.
         */
        public var host: kotlin.String? = null
        /**
         * An object that contains information needed to create a data source connection between an Amazon QuickSight account and Starburst.
         */
        public var oAuthParameters: aws.sdk.kotlin.services.quicksight.model.OAuthParameters? = null
        /**
         * The port for the Starburst data source.
         */
        public var port: kotlin.Int? = null
        /**
         * The product type for the Starburst data source.
         */
        public var productType: aws.sdk.kotlin.services.quicksight.model.StarburstProductType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.StarburstParameters) : this() {
            this.authenticationType = x.authenticationType
            this.catalog = x.catalog
            this.databaseAccessControlRole = x.databaseAccessControlRole
            this.host = x.host
            this.oAuthParameters = x.oAuthParameters
            this.port = x.port
            this.productType = x.productType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.StarburstParameters = StarburstParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.OAuthParameters] inside the given [block]
         */
        public fun oAuthParameters(block: aws.sdk.kotlin.services.quicksight.model.OAuthParameters.Builder.() -> kotlin.Unit) {
            this.oAuthParameters = aws.sdk.kotlin.services.quicksight.model.OAuthParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (catalog == null) catalog = ""
            if (host == null) host = ""
            if (port == null) port = 0
            return this
        }
    }
}
