// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters for Snowflake.
 */
public class SnowflakeParameters private constructor(builder: Builder) {
    /**
     * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth authentication types.
     */
    public val authenticationType: aws.sdk.kotlin.services.quicksight.model.AuthenticationType? = builder.authenticationType
    /**
     * Database.
     */
    public val database: kotlin.String = requireNotNull(builder.database) { "A non-null value must be provided for database" }
    /**
     * The database access control role.
     */
    public val databaseAccessControlRole: kotlin.String? = builder.databaseAccessControlRole
    /**
     * Host.
     */
    public val host: kotlin.String = requireNotNull(builder.host) { "A non-null value must be provided for host" }
    /**
     * An object that contains information needed to create a data source connection between an Amazon QuickSight account and Snowflake.
     */
    public val oAuthParameters: aws.sdk.kotlin.services.quicksight.model.OAuthParameters? = builder.oAuthParameters
    /**
     * Warehouse.
     */
    public val warehouse: kotlin.String = requireNotNull(builder.warehouse) { "A non-null value must be provided for warehouse" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SnowflakeParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeParameters(")
        append("authenticationType=$authenticationType,")
        append("database=$database,")
        append("databaseAccessControlRole=$databaseAccessControlRole,")
        append("host=$host,")
        append("oAuthParameters=$oAuthParameters,")
        append("warehouse=$warehouse")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (database.hashCode())
        result = 31 * result + (databaseAccessControlRole?.hashCode() ?: 0)
        result = 31 * result + (host.hashCode())
        result = 31 * result + (oAuthParameters?.hashCode() ?: 0)
        result = 31 * result + (warehouse.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeParameters

        if (authenticationType != other.authenticationType) return false
        if (database != other.database) return false
        if (databaseAccessControlRole != other.databaseAccessControlRole) return false
        if (host != other.host) return false
        if (oAuthParameters != other.oAuthParameters) return false
        if (warehouse != other.warehouse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SnowflakeParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authentication type that you want to use for your connection. This parameter accepts OAuth and non-OAuth authentication types.
         */
        public var authenticationType: aws.sdk.kotlin.services.quicksight.model.AuthenticationType? = null
        /**
         * Database.
         */
        public var database: kotlin.String? = null
        /**
         * The database access control role.
         */
        public var databaseAccessControlRole: kotlin.String? = null
        /**
         * Host.
         */
        public var host: kotlin.String? = null
        /**
         * An object that contains information needed to create a data source connection between an Amazon QuickSight account and Snowflake.
         */
        public var oAuthParameters: aws.sdk.kotlin.services.quicksight.model.OAuthParameters? = null
        /**
         * Warehouse.
         */
        public var warehouse: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SnowflakeParameters) : this() {
            this.authenticationType = x.authenticationType
            this.database = x.database
            this.databaseAccessControlRole = x.databaseAccessControlRole
            this.host = x.host
            this.oAuthParameters = x.oAuthParameters
            this.warehouse = x.warehouse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SnowflakeParameters = SnowflakeParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.OAuthParameters] inside the given [block]
         */
        public fun oAuthParameters(block: aws.sdk.kotlin.services.quicksight.model.OAuthParameters.Builder.() -> kotlin.Unit) {
            this.oAuthParameters = aws.sdk.kotlin.services.quicksight.model.OAuthParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (database == null) database = ""
            if (host == null) host = ""
            if (warehouse == null) warehouse = ""
            return this
        }
    }
}
