// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon S3 result from the snapshot job. The result includes the `DestinationConfiguration` and the Amazon S3 Uri. If an error occured during the job, the result returns information on the error.
 */
public class SnapshotJobS3Result private constructor(builder: Builder) {
    /**
     * An array of error records that describe any failures that occur while the dashboard snapshot job runs.
     */
    public val errorInfo: List<SnapshotJobResultErrorInfo>? = builder.errorInfo
    /**
     * A list of Amazon S3 bucket configurations that are provided when you make a `StartDashboardSnapshotJob` API call.
     */
    public val s3DestinationConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotS3DestinationConfiguration? = builder.s3DestinationConfiguration
    /**
     * The Amazon S3 Uri.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SnapshotJobS3Result = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotJobS3Result(")
        append("errorInfo=$errorInfo,")
        append("s3DestinationConfiguration=$s3DestinationConfiguration,")
        append("s3Uri=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorInfo?.hashCode() ?: 0
        result = 31 * result + (s3DestinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotJobS3Result

        if (errorInfo != other.errorInfo) return false
        if (s3DestinationConfiguration != other.s3DestinationConfiguration) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SnapshotJobS3Result = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of error records that describe any failures that occur while the dashboard snapshot job runs.
         */
        public var errorInfo: List<SnapshotJobResultErrorInfo>? = null
        /**
         * A list of Amazon S3 bucket configurations that are provided when you make a `StartDashboardSnapshotJob` API call.
         */
        public var s3DestinationConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotS3DestinationConfiguration? = null
        /**
         * The Amazon S3 Uri.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SnapshotJobS3Result) : this() {
            this.errorInfo = x.errorInfo
            this.s3DestinationConfiguration = x.s3DestinationConfiguration
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SnapshotJobS3Result = SnapshotJobS3Result(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SnapshotS3DestinationConfiguration] inside the given [block]
         */
        public fun s3DestinationConfiguration(block: aws.sdk.kotlin.services.quicksight.model.SnapshotS3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3DestinationConfiguration = aws.sdk.kotlin.services.quicksight.model.SnapshotS3DestinationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
