// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains information that identifies the snapshot that needs to be generated.
 */
public class SnapshotFileSheetSelection private constructor(builder: Builder) {
    /**
     * The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can choose one of the following options.
     * + `ALL_VISUALS` - Selects all visuals that are on the sheet. This value is required if the snapshot is a PDF.
     * + `SELECTED_VISUALS` - Select the visual that you want to add to the snapshot. This value is required if the snapshot is a CSV or Excel workbook.
     */
    public val selectionScope: aws.sdk.kotlin.services.quicksight.model.SnapshotFileSheetSelectionScope = requireNotNull(builder.selectionScope) { "A non-null value must be provided for selectionScope" }
    /**
     * The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV, Excel, and PDF format types.
     */
    public val sheetId: kotlin.String = requireNotNull(builder.sheetId) { "A non-null value must be provided for sheetId" }
    /**
     * A structure that lists the IDs of the visuals in the selected sheet. Supported visual types are table, pivot table visuals. This value is required if you are generating a CSV or Excel workbook. This value supports a maximum of 1 visual ID for CSV and 5 visual IDs across up to 5 sheet selections for Excel. If you are generating an Excel workbook, the order of the visual IDs provided in this structure determines the order of the worksheets in the Excel file.
     */
    public val visualIds: List<String>? = builder.visualIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SnapshotFileSheetSelection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotFileSheetSelection(")
        append("selectionScope=$selectionScope,")
        append("sheetId=$sheetId,")
        append("visualIds=$visualIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = selectionScope.hashCode()
        result = 31 * result + (sheetId.hashCode())
        result = 31 * result + (visualIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotFileSheetSelection

        if (selectionScope != other.selectionScope) return false
        if (sheetId != other.sheetId) return false
        if (visualIds != other.visualIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SnapshotFileSheetSelection = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can choose one of the following options.
         * + `ALL_VISUALS` - Selects all visuals that are on the sheet. This value is required if the snapshot is a PDF.
         * + `SELECTED_VISUALS` - Select the visual that you want to add to the snapshot. This value is required if the snapshot is a CSV or Excel workbook.
         */
        public var selectionScope: aws.sdk.kotlin.services.quicksight.model.SnapshotFileSheetSelectionScope? = null
        /**
         * The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV, Excel, and PDF format types.
         */
        public var sheetId: kotlin.String? = null
        /**
         * A structure that lists the IDs of the visuals in the selected sheet. Supported visual types are table, pivot table visuals. This value is required if you are generating a CSV or Excel workbook. This value supports a maximum of 1 visual ID for CSV and 5 visual IDs across up to 5 sheet selections for Excel. If you are generating an Excel workbook, the order of the visual IDs provided in this structure determines the order of the worksheets in the Excel file.
         */
        public var visualIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SnapshotFileSheetSelection) : this() {
            this.selectionScope = x.selectionScope
            this.sheetId = x.sheetId
            this.visualIds = x.visualIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SnapshotFileSheetSelection = SnapshotFileSheetSelection(this)

        internal fun correctErrors(): Builder {
            if (selectionScope == null) selectionScope = SnapshotFileSheetSelectionScope.SdkUnknown("no value provided")
            if (sheetId == null) sheetId = ""
            return this
        }
    }
}
