// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains the information for the snapshot that you want to generate. This information is provided by you when you start a new snapshot job.
 */
public class SnapshotFile private constructor(builder: Builder) {
    /**
     * The format of the snapshot file to be generated. You can choose between `CSV`, `Excel`, or `PDF`.
     */
    public val formatType: aws.sdk.kotlin.services.quicksight.model.SnapshotFileFormatType = requireNotNull(builder.formatType) { "A non-null value must be provided for formatType" }
    /**
     * A list of `SnapshotFileSheetSelection` objects that contain information on the dashboard sheet that is exported. These objects provide information about the snapshot artifacts that are generated during the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1 configuration for PDF.
     */
    public val sheetSelections: List<SnapshotFileSheetSelection> = requireNotNull(builder.sheetSelections) { "A non-null value must be provided for sheetSelections" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SnapshotFile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotFile(")
        append("formatType=$formatType,")
        append("sheetSelections=$sheetSelections")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = formatType.hashCode()
        result = 31 * result + (sheetSelections.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotFile

        if (formatType != other.formatType) return false
        if (sheetSelections != other.sheetSelections) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SnapshotFile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The format of the snapshot file to be generated. You can choose between `CSV`, `Excel`, or `PDF`.
         */
        public var formatType: aws.sdk.kotlin.services.quicksight.model.SnapshotFileFormatType? = null
        /**
         * A list of `SnapshotFileSheetSelection` objects that contain information on the dashboard sheet that is exported. These objects provide information about the snapshot artifacts that are generated during the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1 configuration for PDF.
         */
        public var sheetSelections: List<SnapshotFileSheetSelection>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SnapshotFile) : this() {
            this.formatType = x.formatType
            this.sheetSelections = x.sheetSelections
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SnapshotFile = SnapshotFile(this)

        internal fun correctErrors(): Builder {
            if (formatType == null) formatType = SnapshotFileFormatType.SdkUnknown("no value provided")
            if (sheetSelections == null) sheetSelections = emptyList()
            return this
        }
    }
}
