// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration of the dashboard snapshot.
 */
public class SnapshotConfiguration private constructor(builder: Builder) {
    /**
     * A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.
     */
    public val destinationConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotDestinationConfiguration? = builder.destinationConfiguration
    /**
     * A list of `SnapshotJobResultFileGroup` objects that contain information about the snapshot that is generated. This list can hold a maximum of 6 `FileGroup` configurations.
     */
    public val fileGroups: List<SnapshotFileGroup> = requireNotNull(builder.fileGroups) { "A non-null value must be provided for fileGroups" }
    /**
     * A list of Amazon QuickSight parameters and the list's override values.
     */
    public val parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = builder.parameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnapshotConfiguration(")
        append("destinationConfiguration=$destinationConfiguration,")
        append("fileGroups=$fileGroups,")
        append("parameters=$parameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfiguration?.hashCode() ?: 0
        result = 31 * result + (fileGroups.hashCode())
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnapshotConfiguration

        if (destinationConfiguration != other.destinationConfiguration) return false
        if (fileGroups != other.fileGroups) return false
        if (parameters != other.parameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A structure that contains information on the Amazon S3 bucket that the generated snapshot is stored in.
         */
        public var destinationConfiguration: aws.sdk.kotlin.services.quicksight.model.SnapshotDestinationConfiguration? = null
        /**
         * A list of `SnapshotJobResultFileGroup` objects that contain information about the snapshot that is generated. This list can hold a maximum of 6 `FileGroup` configurations.
         */
        public var fileGroups: List<SnapshotFileGroup>? = null
        /**
         * A list of Amazon QuickSight parameters and the list's override values.
         */
        public var parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration) : this() {
            this.destinationConfiguration = x.destinationConfiguration
            this.fileGroups = x.fileGroups
            this.parameters = x.parameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SnapshotConfiguration = SnapshotConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SnapshotDestinationConfiguration] inside the given [block]
         */
        public fun destinationConfiguration(block: aws.sdk.kotlin.services.quicksight.model.SnapshotDestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.destinationConfiguration = aws.sdk.kotlin.services.quicksight.model.SnapshotDestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.quicksight.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.quicksight.model.Parameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (fileGroups == null) fileGroups = emptyList()
            return this
        }
    }
}
