// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Options that determine the layout and display options of a chart's small multiples.
 */
public class SmallMultiplesOptions private constructor(builder: Builder) {
    /**
     * Sets the maximum number of visible columns to display in the grid of small multiples panels.
     *
     * The default is `Auto`, which automatically adjusts the columns in the grid to fit the overall layout and size of the given chart.
     */
    public val maxVisibleColumns: kotlin.Long? = builder.maxVisibleColumns
    /**
     * Sets the maximum number of visible rows to display in the grid of small multiples panels.
     *
     * The default value is `Auto`, which automatically adjusts the rows in the grid to fit the overall layout and size of the given chart.
     */
    public val maxVisibleRows: kotlin.Long? = builder.maxVisibleRows
    /**
     * Configures the display options for each small multiples panel.
     */
    public val panelConfiguration: aws.sdk.kotlin.services.quicksight.model.PanelConfiguration? = builder.panelConfiguration
    /**
     * The properties of a small multiples X axis.
     */
    public val xAxis: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties? = builder.xAxis
    /**
     * The properties of a small multiples Y axis.
     */
    public val yAxis: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties? = builder.yAxis

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SmallMultiplesOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmallMultiplesOptions(")
        append("maxVisibleColumns=$maxVisibleColumns,")
        append("maxVisibleRows=$maxVisibleRows,")
        append("panelConfiguration=$panelConfiguration,")
        append("xAxis=$xAxis,")
        append("yAxis=$yAxis")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxVisibleColumns?.hashCode() ?: 0
        result = 31 * result + (maxVisibleRows?.hashCode() ?: 0)
        result = 31 * result + (panelConfiguration?.hashCode() ?: 0)
        result = 31 * result + (xAxis?.hashCode() ?: 0)
        result = 31 * result + (yAxis?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmallMultiplesOptions

        if (maxVisibleColumns != other.maxVisibleColumns) return false
        if (maxVisibleRows != other.maxVisibleRows) return false
        if (panelConfiguration != other.panelConfiguration) return false
        if (xAxis != other.xAxis) return false
        if (yAxis != other.yAxis) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SmallMultiplesOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Sets the maximum number of visible columns to display in the grid of small multiples panels.
         *
         * The default is `Auto`, which automatically adjusts the columns in the grid to fit the overall layout and size of the given chart.
         */
        public var maxVisibleColumns: kotlin.Long? = null
        /**
         * Sets the maximum number of visible rows to display in the grid of small multiples panels.
         *
         * The default value is `Auto`, which automatically adjusts the rows in the grid to fit the overall layout and size of the given chart.
         */
        public var maxVisibleRows: kotlin.Long? = null
        /**
         * Configures the display options for each small multiples panel.
         */
        public var panelConfiguration: aws.sdk.kotlin.services.quicksight.model.PanelConfiguration? = null
        /**
         * The properties of a small multiples X axis.
         */
        public var xAxis: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties? = null
        /**
         * The properties of a small multiples Y axis.
         */
        public var yAxis: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesOptions) : this() {
            this.maxVisibleColumns = x.maxVisibleColumns
            this.maxVisibleRows = x.maxVisibleRows
            this.panelConfiguration = x.panelConfiguration
            this.xAxis = x.xAxis
            this.yAxis = x.yAxis
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SmallMultiplesOptions = SmallMultiplesOptions(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.PanelConfiguration] inside the given [block]
         */
        public fun panelConfiguration(block: aws.sdk.kotlin.services.quicksight.model.PanelConfiguration.Builder.() -> kotlin.Unit) {
            this.panelConfiguration = aws.sdk.kotlin.services.quicksight.model.PanelConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties] inside the given [block]
         */
        public fun xAxis(block: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties.Builder.() -> kotlin.Unit) {
            this.xAxis = aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties] inside the given [block]
         */
        public fun yAxis(block: aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties.Builder.() -> kotlin.Unit) {
            this.yAxis = aws.sdk.kotlin.services.quicksight.model.SmallMultiplesAxisProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
