// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An image that is located on a sheet.
 */
public class SheetImage private constructor(builder: Builder) {
    /**
     * A list of custom actions that are configured for an image.
     */
    public val actions: List<ImageCustomAction>? = builder.actions
    /**
     * The alt text for the image.
     */
    public val imageContentAltText: kotlin.String? = builder.imageContentAltText
    /**
     * The general image interactions setup for an image.
     */
    public val interactions: aws.sdk.kotlin.services.quicksight.model.ImageInteractionOptions? = builder.interactions
    /**
     * Determines how the image is scaled.
     */
    public val scaling: aws.sdk.kotlin.services.quicksight.model.SheetImageScalingConfiguration? = builder.scaling
    /**
     * The ID of the sheet image.
     */
    public val sheetImageId: kotlin.String = requireNotNull(builder.sheetImageId) { "A non-null value must be provided for sheetImageId" }
    /**
     * The source of the image.
     */
    public val source: aws.sdk.kotlin.services.quicksight.model.SheetImageSource? = builder.source
    /**
     * The tooltip to be shown when hovering over the image.
     */
    public val tooltip: aws.sdk.kotlin.services.quicksight.model.SheetImageTooltipConfiguration? = builder.tooltip

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SheetImage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SheetImage(")
        append("actions=$actions,")
        append("imageContentAltText=$imageContentAltText,")
        append("interactions=$interactions,")
        append("scaling=$scaling,")
        append("sheetImageId=$sheetImageId,")
        append("source=$source,")
        append("tooltip=$tooltip")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (imageContentAltText?.hashCode() ?: 0)
        result = 31 * result + (interactions?.hashCode() ?: 0)
        result = 31 * result + (scaling?.hashCode() ?: 0)
        result = 31 * result + (sheetImageId.hashCode())
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tooltip?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SheetImage

        if (actions != other.actions) return false
        if (imageContentAltText != other.imageContentAltText) return false
        if (interactions != other.interactions) return false
        if (scaling != other.scaling) return false
        if (sheetImageId != other.sheetImageId) return false
        if (source != other.source) return false
        if (tooltip != other.tooltip) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SheetImage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of custom actions that are configured for an image.
         */
        public var actions: List<ImageCustomAction>? = null
        /**
         * The alt text for the image.
         */
        public var imageContentAltText: kotlin.String? = null
        /**
         * The general image interactions setup for an image.
         */
        public var interactions: aws.sdk.kotlin.services.quicksight.model.ImageInteractionOptions? = null
        /**
         * Determines how the image is scaled.
         */
        public var scaling: aws.sdk.kotlin.services.quicksight.model.SheetImageScalingConfiguration? = null
        /**
         * The ID of the sheet image.
         */
        public var sheetImageId: kotlin.String? = null
        /**
         * The source of the image.
         */
        public var source: aws.sdk.kotlin.services.quicksight.model.SheetImageSource? = null
        /**
         * The tooltip to be shown when hovering over the image.
         */
        public var tooltip: aws.sdk.kotlin.services.quicksight.model.SheetImageTooltipConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SheetImage) : this() {
            this.actions = x.actions
            this.imageContentAltText = x.imageContentAltText
            this.interactions = x.interactions
            this.scaling = x.scaling
            this.sheetImageId = x.sheetImageId
            this.source = x.source
            this.tooltip = x.tooltip
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SheetImage = SheetImage(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ImageInteractionOptions] inside the given [block]
         */
        public fun interactions(block: aws.sdk.kotlin.services.quicksight.model.ImageInteractionOptions.Builder.() -> kotlin.Unit) {
            this.interactions = aws.sdk.kotlin.services.quicksight.model.ImageInteractionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SheetImageScalingConfiguration] inside the given [block]
         */
        public fun scaling(block: aws.sdk.kotlin.services.quicksight.model.SheetImageScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scaling = aws.sdk.kotlin.services.quicksight.model.SheetImageScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SheetImageSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.quicksight.model.SheetImageSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.quicksight.model.SheetImageSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SheetImageTooltipConfiguration] inside the given [block]
         */
        public fun tooltip(block: aws.sdk.kotlin.services.quicksight.model.SheetImageTooltipConfiguration.Builder.() -> kotlin.Unit) {
            this.tooltip = aws.sdk.kotlin.services.quicksight.model.SheetImageTooltipConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (sheetImageId == null) sheetImageId = ""
            return this
        }
    }
}
