// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A sheet is an object that contains a set of visuals that are viewed together on one page in a paginated report. Every analysis and dashboard must contain at least one sheet.
 */
public class SheetDefinition private constructor(builder: Builder) {
    /**
     * The layout content type of the sheet. Choose one of the following options:
     * + `PAGINATED`: Creates a sheet for a paginated report.
     * + `INTERACTIVE`: Creates a sheet for an interactive dashboard.
     */
    public val contentType: aws.sdk.kotlin.services.quicksight.model.SheetContentType? = builder.contentType
    /**
     * A list of visual custom actions for the sheet.
     */
    public val customActionDefaults: aws.sdk.kotlin.services.quicksight.model.VisualCustomActionDefaults? = builder.customActionDefaults
    /**
     * A description of the sheet.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of filter controls that are on a sheet.
     *
     * For more information, see [Adding filter controls to analysis sheets](https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html) in the *Amazon QuickSight User Guide*.
     */
    public val filterControls: List<FilterControl>? = builder.filterControls
    /**
     * A list of images on a sheet.
     */
    public val images: List<SheetImage>? = builder.images
    /**
     * Layouts define how the components of a sheet are arranged.
     *
     * For more information, see [Types of layout](https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html) in the *Amazon QuickSight User Guide*.
     */
    public val layouts: List<Layout>? = builder.layouts
    /**
     * The name of the sheet. This name is displayed on the sheet's tab in the Amazon QuickSight console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of parameter controls that are on a sheet.
     *
     * For more information, see [Using a Control with a Parameter in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html) in the *Amazon QuickSight User Guide*.
     */
    public val parameterControls: List<ParameterControl>? = builder.parameterControls
    /**
     * The control layouts of the sheet.
     */
    public val sheetControlLayouts: List<SheetControlLayout>? = builder.sheetControlLayouts
    /**
     * The unique identifier of a sheet.
     */
    public val sheetId: kotlin.String = requireNotNull(builder.sheetId) { "A non-null value must be provided for sheetId" }
    /**
     * The text boxes that are on a sheet.
     */
    public val textBoxes: List<SheetTextBox>? = builder.textBoxes
    /**
     * The title of the sheet.
     */
    public val title: kotlin.String? = builder.title
    /**
     * A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
     */
    public val visuals: List<Visual>? = builder.visuals

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.SheetDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SheetDefinition(")
        append("contentType=$contentType,")
        append("customActionDefaults=$customActionDefaults,")
        append("description=$description,")
        append("filterControls=$filterControls,")
        append("images=$images,")
        append("layouts=$layouts,")
        append("name=$name,")
        append("parameterControls=$parameterControls,")
        append("sheetControlLayouts=$sheetControlLayouts,")
        append("sheetId=$sheetId,")
        append("textBoxes=$textBoxes,")
        append("title=$title,")
        append("visuals=$visuals")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (customActionDefaults?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (filterControls?.hashCode() ?: 0)
        result = 31 * result + (images?.hashCode() ?: 0)
        result = 31 * result + (layouts?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameterControls?.hashCode() ?: 0)
        result = 31 * result + (sheetControlLayouts?.hashCode() ?: 0)
        result = 31 * result + (sheetId.hashCode())
        result = 31 * result + (textBoxes?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (visuals?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SheetDefinition

        if (contentType != other.contentType) return false
        if (customActionDefaults != other.customActionDefaults) return false
        if (description != other.description) return false
        if (filterControls != other.filterControls) return false
        if (images != other.images) return false
        if (layouts != other.layouts) return false
        if (name != other.name) return false
        if (parameterControls != other.parameterControls) return false
        if (sheetControlLayouts != other.sheetControlLayouts) return false
        if (sheetId != other.sheetId) return false
        if (textBoxes != other.textBoxes) return false
        if (title != other.title) return false
        if (visuals != other.visuals) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.SheetDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The layout content type of the sheet. Choose one of the following options:
         * + `PAGINATED`: Creates a sheet for a paginated report.
         * + `INTERACTIVE`: Creates a sheet for an interactive dashboard.
         */
        public var contentType: aws.sdk.kotlin.services.quicksight.model.SheetContentType? = null
        /**
         * A list of visual custom actions for the sheet.
         */
        public var customActionDefaults: aws.sdk.kotlin.services.quicksight.model.VisualCustomActionDefaults? = null
        /**
         * A description of the sheet.
         */
        public var description: kotlin.String? = null
        /**
         * The list of filter controls that are on a sheet.
         *
         * For more information, see [Adding filter controls to analysis sheets](https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html) in the *Amazon QuickSight User Guide*.
         */
        public var filterControls: List<FilterControl>? = null
        /**
         * A list of images on a sheet.
         */
        public var images: List<SheetImage>? = null
        /**
         * Layouts define how the components of a sheet are arranged.
         *
         * For more information, see [Types of layout](https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html) in the *Amazon QuickSight User Guide*.
         */
        public var layouts: List<Layout>? = null
        /**
         * The name of the sheet. This name is displayed on the sheet's tab in the Amazon QuickSight console.
         */
        public var name: kotlin.String? = null
        /**
         * The list of parameter controls that are on a sheet.
         *
         * For more information, see [Using a Control with a Parameter in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html) in the *Amazon QuickSight User Guide*.
         */
        public var parameterControls: List<ParameterControl>? = null
        /**
         * The control layouts of the sheet.
         */
        public var sheetControlLayouts: List<SheetControlLayout>? = null
        /**
         * The unique identifier of a sheet.
         */
        public var sheetId: kotlin.String? = null
        /**
         * The text boxes that are on a sheet.
         */
        public var textBoxes: List<SheetTextBox>? = null
        /**
         * The title of the sheet.
         */
        public var title: kotlin.String? = null
        /**
         * A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
         */
        public var visuals: List<Visual>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.SheetDefinition) : this() {
            this.contentType = x.contentType
            this.customActionDefaults = x.customActionDefaults
            this.description = x.description
            this.filterControls = x.filterControls
            this.images = x.images
            this.layouts = x.layouts
            this.name = x.name
            this.parameterControls = x.parameterControls
            this.sheetControlLayouts = x.sheetControlLayouts
            this.sheetId = x.sheetId
            this.textBoxes = x.textBoxes
            this.title = x.title
            this.visuals = x.visuals
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.SheetDefinition = SheetDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VisualCustomActionDefaults] inside the given [block]
         */
        public fun customActionDefaults(block: aws.sdk.kotlin.services.quicksight.model.VisualCustomActionDefaults.Builder.() -> kotlin.Unit) {
            this.customActionDefaults = aws.sdk.kotlin.services.quicksight.model.VisualCustomActionDefaults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (sheetId == null) sheetId = ""
            return this
        }
    }
}
