// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An optional structure that contains the Amazon S3 bucket configuration that the generated snapshots are stored in. If you don't provide this information, generated snapshots are stored in the default Amazon QuickSight bucket.
 */
public class S3BucketConfiguration private constructor(builder: Builder) {
    /**
     * The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The prefix of the Amazon S3 bucket that the generated snapshots are stored in.
     */
    public val bucketPrefix: kotlin.String = requireNotNull(builder.bucketPrefix) { "A non-null value must be provided for bucketPrefix" }
    /**
     * The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that the `StartDashboardSnapshotJob` API call is made.
     */
    public val bucketRegion: kotlin.String = requireNotNull(builder.bucketRegion) { "A non-null value must be provided for bucketRegion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.S3BucketConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketConfiguration(")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("bucketRegion=$bucketRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (bucketPrefix.hashCode())
        result = 31 * result + (bucketRegion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketConfiguration

        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (bucketRegion != other.bucketRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.S3BucketConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The prefix of the Amazon S3 bucket that the generated snapshots are stored in.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that the `StartDashboardSnapshotJob` API call is made.
         */
        public var bucketRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.S3BucketConfiguration) : this() {
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.bucketRegion = x.bucketRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.S3BucketConfiguration = S3BucketConfiguration(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (bucketPrefix == null) bucketPrefix = ""
            if (bucketRegion == null) bucketRegion = ""
            return this
        }
    }
}
